<?php 
/**
 * Register sub menu page for Travel Guide
 * 
 * @see https://developer.wordpress.org/reference/functions/add_submenu_page/
 */
if( ! class_exists( 'WP_Travel_Travel_Guide_Admin_Menu' ) ){

	class WP_Travel_Travel_Guide_Admin_Menu{


		/**
		 * The single instance of the class.
		 *
		 * @var string $_instance
		 */
		protected static $instance = null;


		/**
		 * Module Name.
		 *
		 * @var string
		 */
		protected $menu_slug = 'travel-guide';


		/**
		 * Main WP_Travel_Tour_Guide Instance.
		 * Ensures only one instance of WP_Travel_Tour_Guide is loaded or can be loaded.
		 *
		 * @return WP_Travel_Tour_Guide - Main instance.
		 */
		public static function get_instance() {
		    if ( ! self::$instance ) {
		        self::$instance = new self();
		    }
		    return self::$instance;
		}


		/**
		 * Constructor.
		 */
		public function __construct(){
			add_action( 'admin_menu', array( $this, 'register_menu' ) );
			add_filter( 'wp_travel_settings_fields', array( $this, 'settings_fields' ) );
		}

		public function settings_fields( $settings ) {
			$settings['show_wp_travel_travel_guide']    = 'yes';
			return $settings;
		}


		/**
		 * Adding sun menu .
		 */
		public function register_menu(){
			add_submenu_page(
				'edit.php?post_type=itinerary-booking',
		        esc_html__( 'Travel Guide', 'wp-travel-pro' ),
		        esc_html__( 'Travel Guide', 'wp-travel-pro' ),
		        'manage_options',
		        $this->menu_slug,
		        array( $this, 'render' )
		    ); 
		}

		public function render(){
			echo '<div id="wp-travel-travel-guide"></div>';
		}
	}
	
	WP_Travel_Travel_Guide_Admin_Menu::get_instance();
}

/**
 * Adding all available guides to api
 * 
 * @param array $options Attributes.
 * @param array $settings Attributes.
 *
 * @return array
 */
if ( !function_exists('wp_travel_tour_guide_guide_lists') ) {

	function wp_travel_tour_guide_guide_lists( $options, $settings ){

		$get_guides = get_users( array( 'role__in' => array( 'travel-guide' ) ) );

		$guide_list = array();

		foreach ($get_guides as $value) {
		
			$guide_data['id'] = $value->data->ID;
			$guide_data['display_name'] = $value->data->display_name;
			$guide_data['user_email'] = $value->data->user_email;
			$guide_data['user_login'] = $value->data->user_login;
			array_push( $guide_list, $guide_data );
			
		}

		$options[ 'guides' ] = $guide_list;

		return $options;

	}

	add_filter( 'wp_travel_settings_options', 'wp_travel_tour_guide_guide_lists', 10, 2 );
}



/**
 * Adding all available guides to api
 * 
 * @param array $trip_data Attributes.
 * @param int $trip_id Attributes.
 *
 * @return array
 */
if ( !function_exists('wp_travel_tour_guide_selected_guide') ) {


	function wp_travel_tour_guide_selected_guide( $trip_data, $trip_id ){
		$guides = get_post_meta( $trip_id, 'selected_guides', true );
		$trip_data['selected_guides'] = is_array( $guides ) ? $guides : [];
		return $trip_data;
	}
	
	add_filter( 'wp_travel_trip_data', 'wp_travel_tour_guide_selected_guide', 10, 2 );
}

/**
 * store selected guides in database
 * 
 * @param array $trip_data Attributes.
 * @param int $trip_id Attributes.
 *
 */
if ( !function_exists('wp_travel_tour_guide_selected_guides_meta') ) {
	function wp_travel_tour_guide_selected_guides_meta(  $data, $trip_id ){
		update_post_meta( $trip_id, 'selected_guides', ( array ) $data->selected_guides );
	}
	add_action( 'wp_travel_update_trip_data', 'wp_travel_tour_guide_selected_guides_meta', 10, 2 );
}

/**
 * Adding Guide Tabs
 * 
 * @param array $tabs Attributes.
 *
 *	@return array
 */
if ( !function_exists('wp_travel_tour_guide_tab') ) { 

	function wp_travel_tour_guide_tab( $tabs ) {

		global $post;
		$post_id            = isset( $post->ID ) ? $post->ID : '';

		$tabs['guide'] = array(
			'label'        => 'Guide',
			'label_class'  => '',
			'content'      => wp_travel_tour_guide_front_template( ),
			'use_global'   => 'yes',
			'show_in_menu' => 'no',
		);

		return $tabs;
	}
	add_filter( 'wp_travel_default_trip_tabs', 'wp_travel_tour_guide_tab' );
}


/**
 * Guide Tab callback function
 * 
 *	@return void
 */
if ( !function_exists('wp_travel_tour_guide_front_template') ) { 

	function wp_travel_tour_guide_front_template(){

		global $post;
		$post_id = isset( $post->ID ) ? $post->ID : '';	
		$guides_ids = get_post_meta( $post_id, 'selected_guides', true );

		ob_start();
		?>
			<div id="wp-travel-travel-guide-fornt-guide-tab-template">
				
			</div>
		<?php
		return ob_get_clean();
	}	

}
