<?php 
/**
 * CRUD for user
 * 
 * @since WP Travel Travel Guide Core 1.0
 */ 
namespace WP_Travel_Travel_Guide_Core;

if( !class_exists( 'Database' ) ){

	class Database{

		/**
		 * Get all the Travel Guides
		 * 
		 * @see https://developer.wordpress.org/reference/functions/get_users/
		 */
		public function get( $args ){

			$users = get_users( $args );
			$data  = array();
			
			if( is_array( $users ) && count( $users ) > 0 ){
				foreach( $users as $u ){
					$d = ( array ) $u->data;
					$d[ 'user_slogan' ]  = get_user_meta( $u->ID, 'user_slogan', true );
					$d[ 'guide_unique_id' ]  = get_user_meta( $u->ID, 'guide_unique_id', true );
					$d[ 'guide_url' ]  = get_post( get_posts( array( 'name' => $u->user_login, 'post_type' => 'travel-guide', ) )[0]->ID )->guid ;
					$d[ 'user_phone' ]  = get_user_meta( $u->ID, 'user_phone', true );
					$d[ 'city' ]        = get_user_meta( $u->ID, 'city', true );
					$d[ 'country' ]     = get_user_meta( $u->ID, 'country', true );
					$d[ 'age' ]         = get_user_meta( $u->ID, 'age', true );
					$d[ 'join_year' ]   = get_user_meta( $u->ID, 'join_year', true );
					$d[ 'facebook_link' ]   = get_user_meta( $u->ID, 'facebook_link', true );
					$d[ 'instagram_link' ]   = get_user_meta( $u->ID, 'instagram_link', true );
					$d[ 'twitter_link' ]   = get_user_meta( $u->ID, 'twitter_link', true );
					$d[ 'linkedin_link' ]   = get_user_meta( $u->ID, 'linkedin_link', true );
					$d[ 'youtube_link' ]   = get_user_meta( $u->ID, 'youtube_link', true );
					$d[ 'tiktok_link' ]   = get_user_meta( $u->ID, 'youtube_link', true );
					$d[ 'profile_picture' ]   = get_user_meta( $u->ID, 'profile_picture', true );
					$d[ 'language' ]    = get_user_meta( $u->ID, 'language', true );
					$d[ 'gender' ]    	= get_user_meta( $u->ID, 'gender', true );
					$d[ 'description' ] = get_user_meta( $u->ID, 'description', true );
					$d[ 'biography' ] = get_user_meta( $u->ID, 'biography', true );
					$d[ 'trip_list' ] = get_user_meta( $u->ID, 'trip_list', true );
					$d[ 'profile_picture' ] = get_user_meta( $u->ID, 'profile_picture', true );
					$d[ 'profile_picture_url' ] = wp_get_attachment_url( $d[ 'profile_picture' ] );
					$data[] = $d;
				}
			}

			return $data;
		}
		
		/**
		 * Create new user if not exists into the system
		 * 
		 * @see https://developer.wordpress.org/reference/functions/wp_create_user/
		 */ 
		public function save( $userdata ){

			$user_id = wp_insert_user( $userdata );

			if( $user_id ){
				return $user_id;
			}

			return false;
		}

		public function update( $id, $userdata ){
			$userdata[ 'ID' ] = $id;
			return wp_update_user( $userdata );
		}

		/**
		 * Delete user
		 * 
		 * @see https://developer.wordpress.org/reference/functions/wp_delete_user/
		 */ 
		public function delete( $id ){

			if( $id ){
				require_once( ABSPATH . 'wp-admin/includes/user.php' );
				return wp_delete_user( $id );
			}

			return false;
		}

	}

}