<?php 
namespace WP_Travel_Travel_Guide_Core;
/**
 * Adds new role and capabilites for Travel Guide user
 * 
 * @see https://developer.wordpress.org/reference/functions/add_role/
 * @see https://developer.wordpress.org/reference/functions/remove_role/
 * @see https://wordpress.org/support/article/roles-and-capabilities/
 * @since WP Travel Travel Guide Core 1.0
 */
if( !class_exists( 'Role' ) ){

	class Role{

		/**
		 * The single instance of the class.
		 *
		 * @var string $_instance
		 */
		protected static $instance = null;

		/**
		 * Module Name.
		 *
		 * @var string
		 */
		protected $role = 'travel-guide';


		/**
		 * Version.
		 *
		 * @var int
		 */
		protected $role_version = 1;


		/**
		 * Capabilities.
		 *
		 * @var array
		 */
		protected $capabilities = array(
			'read' => true
		);


		/**
		 * Main WP_Travel_travel_guide Instance.
		 * Ensures only one instance of WP_Travel_travel_guide is loaded or can be loaded.
		 *
		 * @return WP_Travel_travel_guide - Main instance.
		 */
		public static function get_instance() {
		    if ( ! self::$instance ) {
		        self::$instance = new self();
		    }
		    return self::$instance;
		}

		public function get(){
			return $this->role;
		}	

		/**
		 * Constructor.
		 */
		public function __construct(){
			add_action( 'init', array( $this, 'add' ) );
		}

		public function add(){

			if( get_option( 'travel_guide_role_version' ) < $this->role_version ) {
				remove_role( $this->get() );
		        add_role( $this->get(), 'Travel Guide', $this->capabilities );
		        update_option( 'travel_guide_role_version', $this->role_version );
		    }
		}
	}

	Role::get_instance();
}