<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WP_Travel_Trip_Weather_Forecast_Core' ) ) :
	class WP_Travel_Trip_Weather_Forecast_Core {
		protected static $ABSPATH;

		protected static $PLUGIN_FILE;

		protected static $VERSION;

		const WP_TRAVEL_TRIP_WEATHER_FORECAST_HANDLE = 'wp_travel_trip_weather_forecast_';

		/**
		 * The single instance of the class.
		 *
		 * @var WP Travel Field Editor Core
		 * @since 1.0.0
		 */
		protected static $_instance = null;

		/**
		 * Main WP_Travel_Trip_Weather_Forecast_Core Instance.
		 * Ensures only one instance of WP_Travel_Trip_Weather_Forecast_Core is loaded or can be loaded.
		 *
		 * @since 1.0.0
		 * @static
		 * @see WP_Travel_Trip_Weather_Forecast_Core()
		 * @return WP_Travel_Trip_Weather_Forecast_Core - Main instance.
		 */
		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}

		/**
		 * Init core.
		 */
		public static function init() {
			self::$ABSPATH     = dirname( __FILE__ ) . '/';
			self::$PLUGIN_FILE = __FILE__;
			self::$VERSION     = '1.0.0';

			if ( function_exists( 'wptravel_get_settings' ) ) {
				$settings = wptravel_get_settings();
			} else {
				$settings = wp_travel_get_settings();
			}

			$enable_trip_weather_forecast = isset( $settings['show_wp_travel_trip_weather_forecast'] ) ? $settings['show_wp_travel_trip_weather_forecast'] : 'yes';

			add_filter( 'wp_travel_settings_fields', array( 'WP_Travel_Trip_Weather_Forecast_Core', 'settings_fields' ) );
			add_action( 'wp_travel_addons_setings_tab_fields', array( 'WP_Travel_Trip_Weather_Forecast_Core', 'plugin_action' ) );
			// if ( 'yes' !== $enable_trip_weather_forecast ) {
			// 	return;
			// }

			add_action( 'admin_enqueue_scripts', array( 'WP_Travel_Trip_Weather_Forecast_Core', 'wp_travel_trip_weather_forecast_admin_styles' ) );
			add_action( 'wp_enqueue_scripts', array( 'WP_Travel_Trip_Weather_Forecast_Core', 'wp_travel_trip_weather_forecast_frontend_styles' ) );
			self::wp_travel_trip_weather_forecast_required_files();

			/**
			 * Filter
			 *
			 * @since wptravel 4.0.6
			 */
			add_filter(
				'wp-travel-script-handles',
				function( $handles ) {
					$handles[] = 'wp_travel_trip_weather_forecast_frontend_scripts';
					return $handles;
				}
			);

		}

		/**
		 * Default settings fields.
		 *
		 * @param array $settings WP Travel Settings.
		 * @return array
		 */
		public static function settings_fields( $settings ) {
			$settings['show_wp_travel_trip_weather_forecast'] = 'yes';
			return $settings;
		}

		/**
		 * Plugin action to show / hide plugin settings and features.
		 */
		public static function plugin_action() {
			if ( function_exists( 'wptravel_get_settings' ) ) {
				$settings = wptravel_get_settings();
			} else {
				$settings = wp_travel_get_settings();
			}

			$field_name  = 'show_wp_travel_trip_weather_forecast';
			$field_label = __( 'WP Travel Trip Weather Forecast', 'wp-travel-pro' );

			$field_value = isset( $settings[ $field_name ] ) ? $settings[ $field_name ] : 'yes'; ?>
			<table class="form-table">
				<tr>
					<th>
						<label for="<?php echo esc_attr( $field_name ); ?>"><?php echo esc_html( $field_label ); ?></label>
					</th>
					<td>
						<span class="show-in-frontend checkbox-default-design">
							<label data-on="ON" data-off="OFF">
								<input value="no" name="<?php echo esc_attr( $field_name ); ?>" type="hidden" />
								<input <?php checked( $field_value, 'yes' ); ?> value="yes" name="<?php echo esc_attr( $field_name ); ?>" id="<?php echo esc_attr( $field_name ); ?>" type="checkbox" />
								<span class="switch"></span>
							</label>
						</span>
						<p class="description"><label for="<?php echo esc_attr( $field_name ); ?>"><?php echo esc_html__( 'Show all your "', 'wp-travel-pro' ) . esc_html( $field_label ) . esc_html__( '" settings and enable its feature.', 'wp-travel-pro' ); ?></label></p>
					</td>
				</tr>
			</table>
			<?php
		}

		/**
		 * Enqueue style and scripts for admin panel.
		 */
		public static function wp_travel_trip_weather_forecast_admin_styles() {
			$switch_to_react = true; // force enable.
			if ( function_exists( 'wptravel_is_react_version_enabled' ) ) {
				$switch_to_react = wptravel_is_react_version_enabled();  // force enable but has filter to include backward compatibility for now.
			}
			$screen = get_current_screen();
			if (  method_exists( 'WP_Travel',  'is_page' )  ) { // @since WP Travel 4.4.2
				$is_settings_page = WP_Travel::is_page( 'settings', true );
			} else {
				$is_settings_page = 'itinerary-booking_page_settings' == $screen->id;
			}
			if ( $is_settings_page ) {
				$deps                   = include_once sprintf( '%s/app/build/wp-travel-settings.asset.php', plugin_dir_path( __FILE__ ) );
				$deps['dependencies'][] = 'jquery';
				wp_enqueue_script( self::WP_TRAVEL_TRIP_WEATHER_FORECAST_HANDLE . 'admin-settings', plugin_dir_url( __FILE__ ) . '/app/build/wp-travel-settings.js', $deps['dependencies'], $deps['version'], true );
			}
			if ( ! $switch_to_react ) {
				// Styles.
				wp_enqueue_style( 'wp_travel_trip_weather_forecast_admin_styles', plugin_dir_url( __FILE__ ) . 'assets/admin-styles.css', array(), '1.0.0' );

				// Scripts.
				wp_enqueue_script( 'wp_travel_trip_weather_forecast_admin_scripts', plugin_dir_url( __FILE__ ) . 'assets/admin-scripts.js', array(), '1.0.0', true );
			}
		}

		/**
		 * Enqueues our external stylesheet for frontend
		 */
		public static function wp_travel_trip_weather_forecast_frontend_styles() {
			// Slick-slider styles.
			// wp_enqueue_style( 'wp-travel-slick' );

			// Styles.
			wp_enqueue_style( 'wp_travel_trip_weather_forecast_frontend_styles', plugin_dir_url( __FILE__ ) . 'assets/frontend-styles.css', array( 'wp-travel-slick' ), '1.0.0' );

			// Slick-slider scripts.
			// wp_enqueue_script( 'wp-travel-slick' );

			// Scripts.
			wp_enqueue_script( 'wp_travel_trip_weather_forecast_frontend_scripts', plugin_dir_url( __FILE__ ) . 'assets/frontend-scripts.js', array( 'wp-travel-slick' ), '1.0.0', true );
		}

		/**
		 * Function to include files after plugin loaded.
		 */
		public static function wp_travel_trip_weather_forecast_required_files() {

			include_once self::$ABSPATH . '/inc/admin-settings-misc-options.php';
			include_once self::$ABSPATH . '/inc/widgets.php';
			include_once self::$ABSPATH . '/inc/templates.php';
			include_once self::$ABSPATH . '/inc/shortcodes.php';

		}
	}
endif;
