/**
 * WP Travel Utilities Backend JS
 */
(function($) {

    function validateEmail(email) {
        var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    }

    $('#wp-travel-utils-global-faq-shortcode').on('click', function() {
        var id = $(this).attr('id');
        var copyText = document.getElementById(id);
        copyText.select();
        document.execCommand("copy");
        alert("Shortcode Copied : " + copyText.value);
    });



    jQuery(document).on('click', '.option-adder', function(e) {
        // if (e.which == 13) {
            e.preventDefault();
            // this = '.notif-email-field';
            if (jQuery(this).siblings( '.notif-email-field' ).val() == '') {
                return;
            }
            if (!validateEmail(jQuery(this).siblings('.notif-email-field').val())) {
                alert('Please Enter a valid Email');
                return;
            }
            var val = jQuery(this).siblings('.notif-email-field').val();
            jQuery(this).siblings('.notif-email-field').val('')
            jQuery(this).siblings('.notif-email-field').siblings('.options-holder').append('<p>' + val + '<input type="hidden" name="' + jQuery(this).siblings('.notif-email-field').attr('name') + '[]" value="' + val + '"/><span class="option-deleter"><span class="dashicons dashicons-no-alt"></span></span></p>')
        // }
    });


    $('#wp-travel-add-new-tab').click(function() {

        var template = wp.template('wp-travel-add-new-tab-template');
        var rand = Math.floor(Math.random() * (999 - 10 + 1)) + 10;
        var custom_global_tab_id = 'wp_travel_global_custom_tab_cnt_' + rand;
        $('#tab-accordion').append(template({ random: rand }));

        tinyMCE.execCommand('mceAddEditor', true, custom_global_tab_id);
        // quicktags({ id: custom_global_tab_id });

        $('.while-empty').hide();
        $('.wp-collapse-open').show();

    });

    $('#wp-travel-add-new-itinerary-tab').click(function() {

        var template = wp.template('wp-travel-add-new-itinerary-tab-template');
        var rand = Math.floor(Math.random() * (999 - 10 + 1)) + 10;
        var custom_itinerary_tab_id = 'wp_travel_itinerary_custom_tab_cnt_' + rand;
        $('#itinerary-customtab-accordion').append(template({ random: rand }));

        tinyMCE.execCommand('mceAddEditor', true, custom_itinerary_tab_id);
        // quicktags({ id: custom_itinerary_tab_id });

        $('.while-empty').hide();
        $('.wp-collapse-open').show();

    });


    $('#wp-travel-add-new-global-faq').click(function() {

        var template = wp.template('wp-travel-utilities-global-faqs');
        var rand = Math.floor(Math.random() * (999 - 10 + 1)) + 10;
        $('#wp-travel-utils-global-content-faq').append(template({ random: rand }));

        $('.while-empty').hide();
        $('.wp-collapse-open').show();

    });

    $('#wt-utils-global-faq-data .wp-travel-sorting-tabs').sortable({
        handle: '.wp-travel-sorting-handle',
    });

    //value bind to label.
    $(document).on('change keyup', "*[bind]", function(e) {
        var to_bind = $(this).attr('bind');
        var value = ('' != $(this).val()) ? $(this).val() : 'Untitled';
        $("*[bind='" + to_bind + "']").html(value);
        $("*[bind='" + to_bind + "']").val($(this).val());
    });

    $(document).on('click', '.wt-utils-accordion-close', function(e) {
        var acc_id = $(this).closest('.tab-accordion').attr('id');
        if (confirm("Are you sure to Delete ?") == true) {
            $(this).closest('div.panel-default').remove();

            var faqs = $('#' + acc_id + ' .panel-default').length;

            // alert(faqs);
            if (faqs > 0) {
                $('.while-empty').hide();
                $('.wp-collapse-open').show();
            } else {
                $('.wp-collapse-open').hide();
                $('.while-empty').show();
            }
        }
        return;
    });

    function show_custom_booking_fields() {
        var price_option_type = $( '#wp-travel-pricing-option-type' ).val();
        if ( 'custom-booking' == price_option_type ) {

            var option_type = jQuery( '#wp-travel-custom-booking-type' ).val();
            $( '.price-option-row' ).addClass( 'hidden' ); // Hide all fields
            $( '.custom-booking-option-row' ).removeClass( 'hidden' ); // Show custom booking all fields
            
            if ( 'custom-link' == option_type ) {
                $( '.custom-booking-field-custom-form' ).addClass( 'hidden' );
                $( '.custom-booking-field-custom-link' ).removeClass( 'hidden' );
            }
            if ( 'custom-form' == option_type ) {
                $( '.custom-booking-field-custom-link' ).addClass( 'hidden' );
                $( '.custom-booking-field-custom-form' ).removeClass( 'hidden' );
            }
        }
    }
    show_custom_booking_fields();

    $( document ).on( 'change', '#wp-travel-pricing-option-type, #wp-travel-custom-booking-type', function() {
        show_custom_booking_fields();
    } );

    $( document ).on( 'change', '#wp-travel-pricing-option-type, #wp-travel-custom-booking-type', function() {
        show_custom_booking_fields();
    } );

    // Faq

    function show_faq_fields() {
        var use_global_faq = $('#wp_travel_utils_use_global_faq_for_trip').is( ':checked' );
        var use_trip_faq = $('#wp_travel_utils_use_trip_faq_for_trip').is( ':checked' );

        // Hide all fields.
        $( '#accordion-faq-data .panel-default' ).hide().find('input, textarea').attr( 'disabled', 'disabled' );
        $( '#accordion-faq-data .panel-default.global-no' ).find('input, textarea ').removeAttr( 'disabled');
        if ( use_global_faq ) {  // show global faq

            $( '#wp_travel_utils_use_trip_faq_for_trip' ).closest('tr' ).show();

            $( '#accordion-faq-data .panel-default.global-yes' ).show().find('input, textarea').removeAttr( 'disabled');
            if ( use_trip_faq ) { // show trip faq
                $( '#accordion-faq-data .panel-default.global-no' ).show();
            }

        } else { // show trip faq

            $( '#wp_travel_utils_use_trip_faq_for_trip' ).closest('tr' ).hide();

            $( '#accordion-faq-data .panel-default.global-no' ).show();
            
            // Disable global value if not checked global. [ comment this line if need to save global faq]
            $( '#accordion-faq-data .panel-default.global-yes' ).attr( 'disabled', 'disabled' );
        }
    }
    show_faq_fields();
    $( document ).on( 'change', '#wp_travel_utils_use_global_faq_for_trip, #wp_travel_utils_use_trip_faq_for_trip', function() {
        show_faq_fields();

        // Show Hide Add new question and open all
        // var acc_id = $(this).closest('.tab-accordion').attr('id');
        // var faqs = $('#' + acc_id + ' .panel-default:visible').length;

        // if ( faqs < 1  ) {

        // }
    } );

    // Add  New Pricing option category
    $(document).on('click', '.wp-travel-add-new-pricing-category', function() {
        var parent = $(this).closest('.repeat-row').siblings('.new-category-row-content').attr('id');
        var template = wp.template('wp-travel-pricing-options-category');
        var price_key = $(this).closest('.panel-wrap').find('.wp-travel-price-key').val();
        if ( ! price_key ) {
            var price_key = Math.random().toString(36).substring(2, 15) + Math.random().toString(36).substring(2, 15);
        }
        var category_id = Math.random().toString(36).substring(2, 15) + Math.random().toString(36).substring(2, 15);

        $('#' + parent ).prepend(template({ random: price_key, category_id:category_id })).children('.new-category-repeator:first').hide().slideDown("first");
        // $('#' + parent ).children(".new-category-repeator").slideDown("fast");
    });

    // Need TO move in utilities
    $(document).on( 'click', '.wp-travel-remove-pricing-category', function(e){
        e.preventDefault()
        var parent = $(this).parent( '.new-category-repeator' );

        var category_length = $(this).closest( '.new-category-row' ).find('.new-category-repeator').length;
        if ( category_length <= 1 ) {
            alert( 'Require atleast one Pricing.' );
            return;
        }
        var c = confirm( 'Are you sure to remove pricing?' );
        if ( c ) {
            parent.slideUp( "fast", function(){
                $(this).remove();
            } );
        }
    } );

    // For Trip Time.
    $( document ).on( 'click', '.enable_trip_time', function(e) {
        $(this).closest('.repeat-row').find('.wp-travel-time-picker-wrapper').addClass('hidden')
        $(this).closest('.repeat-row').siblings('.wp-travel-trip-time-row').addClass('hidden')

        if ( $(this).is( ':checked' ) ) {
            $(this).closest('.repeat-row').find('.wp-travel-time-picker-wrapper').removeClass('hidden')
            $(this).closest('.repeat-row').siblings('.wp-travel-trip-time-row').removeClass('hidden')
        }
    } );

    $( document ).on( 'click', '.wp-travel-add-new-time', function(e) {
        e.preventDefault();
        var parent = $(this).closest('.repeat-row').siblings('.wp-travel-trip-time-row');
        var time = $(this).siblings( '.wp-travel-timepicker' ).val();

        if ( ! time ) {
            
            $(this).siblings( '.wp-travel-timepicker' ).addClass( 'error' );
            return;
        }

        var exists = false;
        $(this).closest('.repeat-row').siblings('.wp-travel-trip-time-row').find('.wp-travel-trip-time').each( function(){
            if ( $(this).val() ==  time ){
                exists = true;
            }
        } );

        if ( exists ) {
            $(this).siblings( '.wp-travel-timepicker' ).addClass( 'error' );
            return;
        }

        $(this).siblings( '.wp-travel-timepicker' ).removeClass( 'error' );
        var pricing_id = $(this).data('pricing-id');

        var html = '<div class="timepicker-input"><span>' + time + '</span><a href="#" class="timepicker-close close">x</a><input type="hidden" value="' + time + '" class="wp-travel-trip-time" name="wp_travel_trip_time[' + pricing_id + '][times][]" ></div>'

        parent.find( '.wp-travel-time-input' ).append( html );
        parent.find( '.wp-travel-no-trip-time' ).addClass( 'hidden' );
    } );

    $('.wp-travel-time-input').sortable({
        // handle: '.timepicker-input',
        items: '.timepicker-input'
    });

    $(document).on( 'click', '.timepicker-close', function(e) {
        e.preventDefault();
        var parent = $(this).closest( '.wp-travel-time-input' );
        var c = confirm('are you sure, you want to remove?');
        if (c) {
            $(this).closest( '.timepicker-input' ).remove();
        }

        if ( parent.find( '.timepicker-input' ).length == 0 ) {
            $( '.wp-travel-no-trip-time' ).removeClass( 'hidden' );
        }
    } );

    $(document).on( 'click', '.wp-travel-multiple-dates-add-new', function(e) {
        $('.wp-travel-timepicker').wpt_datepicker({
            language: 'en',
            timepicker: true,
            onlyTimepicker: true,
        });
    } );

    // For Trip Time Ends.

}(jQuery));
