<?php
/**
 * Utilities Helper.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get trip data.
function wp_travel_utilities_trip_data( $trip_data, $trip_id ) {

	$trip_meta = get_post_meta( $trip_id );
	if ( ! empty( $trip_meta['wp_travel_pricing_option_type'][0] ) ) {
		$trip_data['pricing_type'] = esc_attr( $trip_meta['wp_travel_pricing_option_type'][0] );
	}
	if ( ! empty( $trip_meta['wp_travel_custom_booking_type'][0] ) ) {
		$trip_data['custom_booking_type'] = esc_attr( $trip_meta['wp_travel_custom_booking_type'][0] );
	}
	if ( ! empty( $trip_meta['wp_travel_custom_booking_form'][0] ) ) {
		$trip_data['custom_booking_form'] = $trip_meta['wp_travel_custom_booking_form'][0];
	}
	if ( ! empty( $trip_meta['wp_travel_custom_booking_link'][0] ) ) {
		$trip_data['custom_booking_link'] = esc_attr( $trip_meta['wp_travel_custom_booking_link'][0] );
	}
	if ( ! empty( $trip_meta['wp_travel_custom_booking_link_text'][0] ) ) {
		$trip_data['custom_booking_link_text'] = esc_attr( $trip_meta['wp_travel_custom_booking_link_text'][0] );
	}
	$custom_booking_link_open_in_new_tab              = ! empty( $trip_meta['wp_travel_custom_booking_link_open_in_new_tab'][0] ) && '1' == $trip_meta['wp_travel_custom_booking_link_open_in_new_tab'][0] ? true : false;
	$trip_data['custom_booking_link_open_in_new_tab'] = $custom_booking_link_open_in_new_tab;
	
	return $trip_data;
}

add_filter( 'wp_travel_trip_data', 'wp_travel_utilities_trip_data', 10, 2 );


// Update trip data.
function wp_travel_utilities_update_trip_data( $trip_data, $trip_id ) {
	$pricing_type = ! empty( $trip_data->pricing_type ) ? $trip_data->pricing_type : 'multiple-price';
	update_post_meta( $trip_id, 'wp_travel_pricing_option_type', sanitize_text_field( $pricing_type ) );

	$custom_booking_type = ! empty( $trip_data->custom_booking_type ) ? $trip_data->custom_booking_type : 'custom-link';
	update_post_meta( $trip_id, 'wp_travel_custom_booking_type', sanitize_text_field( $custom_booking_type ) );

	$custom_booking_form = '';
	if ( isset( $trip_data->custom_booking_form ) ) {
		$post_data           = json_decode( file_get_contents( 'php://input' ), true );
		$custom_booking_form = isset( $post_data['custom_booking_form'] ) ? $post_data['custom_booking_form'] : '';
	}
	update_post_meta( $trip_id, 'wp_travel_custom_booking_form', $custom_booking_form );

	$custom_booking_link = ! empty( $trip_data->custom_booking_link ) ? $trip_data->custom_booking_link : '';
	update_post_meta( $trip_id, 'wp_travel_custom_booking_link', sanitize_text_field( $custom_booking_link ) );

	// $custom_booking_link_text = ! empty( $trip_data->custom_booking_link_text ) ? $trip_data->custom_booking_link_text : '';
	// update_post_meta( $trip_id, 'wp_travel_custom_booking_link_text', sanitize_text_field( $custom_booking_link_text ) );

	$custom_booking_link_open_in_new_tab = ! empty( $trip_data->custom_booking_link_open_in_new_tab ) ? true : false;
	update_post_meta( $trip_id, 'wp_travel_custom_booking_link_open_in_new_tab', $custom_booking_link_open_in_new_tab );
}
add_action( 'wp_travel_update_trip_data', 'wp_travel_utilities_update_trip_data', 10, 2 );

add_filter( 'wp_travel_trip_duration_formating_select', 'wp_travel_return_trip_duration_formated_value', 10, 2 );
function wp_travel_return_trip_duration_formated_value( $old_duration, $new_duration ) {
	return $new_duration;
}

add_filter( 'wp_travel_trip_duration_formating_selects', 'wp_travel_return_trip_duration_formated_values', 10, 2 );
function wp_travel_return_trip_duration_formated_values( $old_duration, $new_duration ) {
	return $new_duration;
}

