<?php
/**
 * WP Travel Customized Trip Code.
 *
 * @package WP_Travel_Utilities
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WP_Travel_Util_Custom_Trip_Code Class.
 */
class WP_Travel_Util_Custom_Trip_Code {
	/**
	 * Private var $post_type.
	 *
	 * @var string
	 */
	private static $post_type = WP_TRAVEL_POST_TYPE;
	/**
	 * Constructor WP_Travel_Util_Custom_Trip_Code.
	 */
	public function __construct() {

		if ( $this->is_enabled() ) {
			// Remove the default metabox.
			add_action( 'do_meta_boxes', array( $this, 'remove_trip_code_mb' ), 10, 2 );
			// Add the new customizable metabox.
			// add_action( 'add_meta_boxes', array( $this, 'register_new_metaboxes' ), 10, 2 );
			// Set Trip code Filter.
			add_filter( 'wp_travel_trip_code', array( $this, 'filter_trip_code' ), 10, 2 );
		}
		// Save trip code and additional settings.
		add_action( 'wp_travel_itinerary_extra_meta_save', array( $this, 'save_trip_code' ) );

	}
	/**
	 * Check for trip code customization enabled.
	 */
	public function is_enabled() {

		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings();
		}

		$enabled = isset( $settings['enable_custom_trip_code_option'] ) ? $settings['enable_custom_trip_code_option'] : 'yes';

		if ( 'yes' === $enabled ) {
			return true;
		} else {

			return false;
		}

	}
	/**
	 * Remove Trip Code Metabox
	 */
	public function remove_trip_code_mb() {
		remove_meta_box( 'wp-travel-' . WP_TRAVEL_POST_TYPE . '-info', WP_TRAVEL_POST_TYPE, 'side' );

	}
	/**
	 * Add new Metaboxes
	 */
	// public function register_new_metaboxes() {
	// 	add_meta_box( 'wp-travel-' . WP_TRAVEL_POST_TYPE . '-trip-code', __( 'Trip Info', 'wp-travel-utilities' ), array( $this, 'wp_travel_trip_code' ), WP_TRAVEL_POST_TYPE, 'side' );
	// }
	/**
	 * Trip Info metabox.
	 *
	 * @param  Object $post Post object.
	 */
	public function wp_travel_trip_code( $post ) {
		if ( ! $post ) {
			return;
		}
		if ( function_exists( 'wptravel_get_trip_code' ) ) {
			$trip_code = wptravel_get_trip_code( $post->ID );
		} else {
			$trip_code = wp_travel_get_trip_code( $post->ID );
		}
		?>
		<table class="form-table trip-info-sidebar">
			<tr>
				<td><label for="wp-travel-detail"><?php esc_html_e( 'Trip Code', 'wp-travel-pro' ); ?></label></td>
				<td><input type="text" name="wp_travel_trip_code" id="wp-travel-trip-code" value="<?php echo esc_attr( $trip_code ); ?>" /></td>
			</tr>
		</table>
		<?php
	}
	/**
	 * Update Trip Meta.
	 */
	public function save_trip_code() {

		global $post;

		if ( ! $post ) {

			return;
		}

		$post_id = $post->ID;

		if ( isset( $_POST['wp_travel_trip_code'] ) ) {

			$wp_travel_trip_code = sanitize_text_field( $_POST['wp_travel_trip_code'] );

			update_post_meta( $post_id, 'wp_travel_trip_code', $wp_travel_trip_code );
		}

		$use_global_faqs = 'no';

		if ( isset( $_POST['wp_travel_utils_use_global_faq_for_trip'] ) ) {

			$use_global_faqs = sanitize_text_field( $_POST['wp_travel_utils_use_global_faq_for_trip'] );

		}
		update_post_meta( $post_id, 'wp_travel_utils_use_global_faq_for_trip', $use_global_faqs );

		$use_trip_faqs = 'no';

		if ( isset( $_POST['wp_travel_utils_use_trip_faq_for_trip'] ) ) {

			$use_trip_faqs = sanitize_text_field( $_POST['wp_travel_utils_use_trip_faq_for_trip'] );

		}
		update_post_meta( $post_id, 'wp_travel_utils_use_trip_faq_for_trip', $use_trip_faqs );



		if ( isset( $_POST['wp_travel_itinerary_custom_tab_cnt_'] ) && is_array( $_POST['wp_travel_itinerary_custom_tab_cnt_'] ) ) {
			$global_tab_settings = $_POST['wp_travel_itinerary_custom_tab_cnt_'];
			$custom_tabs_data = $_POST['wp_travel_itinerary_custom_tab_cnt_'];

			$valid_itinerary_custom_tabs = array();
			foreach ( $custom_tabs_data as $key => $tab ) {
				// Dont Save Empty Tabs.
				if ( ! empty( $tab['label'] ) ) {
	
					$tab['custom'] = 'yes';
					$tab['global'] = 'yes';
	
					// if ( false === array_search( $tab['label'], wp_list_pluck( $global_tab_settings, 'label' ) ) ) {
						$valid_itinerary_custom_tabs[ wp_travel_utilities_slugify_string( $tab['label'] ) ] = $tab;
					// }
				}
			}
			update_post_meta( $post_id, 'wp_travel_itinerary_custom_tab_cnt_', $valid_itinerary_custom_tabs );
		}
		
	}
	/**
	 * Filter through the new trip code
	 */
	public function filter_trip_code( $trip_code, $post_id ) {

		$saved_trip_code = get_post_meta( $post_id, 'wp_travel_trip_code', true );

		if ( ! $saved_trip_code ) {
			return $trip_code;
		} else {
			return $saved_trip_code;
		}
	}

}
// Class Init.
new WP_Travel_Util_Custom_Trip_Code();
