<?php
/**
 * Admin Settings Tabs / Contents.
 *
 * @package WP_Travel
 */

// Add tab.
add_filter( 'wp_travel_settings_tabs', 'wp_travel_add_utilities_addon_settings_tabs' );
// Add tab content callback.
add_action( 'wp_travel_tab_content_before_booking_tamplate', 'wp_travel_utilities_settings_tab_callback', 12 );
// Add FAQ tab content callback.
add_action( 'wp_travel_tabs_content_settings_utilities_faq_global', 'wp_travel_utilities_global_faq_tab_callback', 12, 2 );

// Add itinerary tabs custom callback.
add_action( 'wp_travel_itinerary_custom_tabs', 'wp_travel_utilities_itinerary_custom_tab_callback' );

// Add global FAQ Use option for single trips.
add_action( 'wp_travel_utils_itinerary_global_faq_settings', 'wp_travel_utils_itinerary_global_faq' );

/**
 * Wp_travel_add_utilities_addon_settings_tabs Add Additional Tabs in settings.
 *
 * @param array $tabs_array.
 */
function wp_travel_add_utilities_addon_settings_tabs( $tabs_array ) {

	// FAQs Global tab.
	if ( ! isset( $tabs_array['utilities_faq_global'] ) ) {

		$tabs_array['utilities_faq_global'] = array(
			'tab_label'     => __( 'FAQs', 'wp-travel-pro' ),
			'content_title' => __( 'Global FAQs', 'wp-travel-pro' ),
			'priority'      => 85,
		);
	}

	return $tabs_array;

}
/**
 * Account Settings tab Callback.
 *
 * @param  Array $args Settings arg list.
 */
function wp_travel_utilities_settings_tab_callback( $args ) {

	$enable_custom_trip_code_option = isset( $args['settings']['enable_custom_trip_code_option'] ) ? $args['settings']['enable_custom_trip_code_option'] : 'yes';

	$disable_email_powered_by_text = isset( $args['settings']['disable_email_powered_by_text'] ) ? $args['settings']['disable_email_powered_by_text'] : 'no';

	$powered_by_text = isset( $args['settings']['email_template_powered_by_text'] ) ? $args['settings']['email_template_powered_by_text'] : __( '{sitename} - Powered By: ', 'wp-travel-pro' ) . '<a href="http://wptravel.io/" target="_blank" style="color: #5a418b;text-decoration: none;">WP Travel.</a>';

		echo '<table class="form-table">';
			echo '<tr>';
				echo '<th>';
					echo '<label for="currency">' . esc_html__( 'Remove Powered By Text', 'wp-travel-pro' ) . '</label>';
				echo '</th>';
				echo '<td>';
					echo '<span class="show-in-frontend checkbox-default-design">';
						echo '<label data-on="ON" data-off="OFF">';
							echo '<input' . checked( $disable_email_powered_by_text, 'yes', false ) . ' value="yes" name="disable_email_powered_by_text" id="disable_email_powered_by_text" type="checkbox" />';
							echo '<span class="switch">';
							echo '</span>';
						echo '</label>';
					echo '</span>';
					echo '<p class="description"><label for="disable_email_powered_by_text">' . esc_html__( 'Remove "Powered By" text for all email.', 'wp-travel-pro' ) . '</label></p>';
				echo '</td>';
			echo '</tr>';
			echo '<tr>';
				echo '<th>';
					echo '<label for="currency">' . esc_html__( 'Custom Powered By Text', 'wp-travel-pro' ) . '</label>';
				echo '</th>';
				echo '<td>';
					echo '<textarea name="email_template_powered_by_text" rows="5" cols="40" >' . wp_kses_post( $powered_by_text ) . '</textarea>';
					echo '<p class="description"><label for="email_template_powered_by_text">' . esc_html__( 'Custom footer "Powered By" text for all email.', 'wp-travel-pro' ) . '</label></p>';
				echo '</td>';
			echo '</tr>';
		echo '</table>';

}

add_action( 'wp_travel_custom_global_tabs', 'wp_travel_utilities_global_custom_tabs_callback' );


/**
 * Global Tabs, Custom tabs Options.
 */
function wp_travel_utilities_global_custom_tabs_callback() {

	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}

	$custom_global_tabs = isset( $settings['wp_travel_custom_global_tabs'] ) && '' !== $settings['wp_travel_custom_global_tabs'] ? $settings['wp_travel_custom_global_tabs'] : array();

	?>
		<div class="wp-travel-tab-content-faq-header clearfix">
			<?php
			if ( is_array( $custom_global_tabs ) && count( $custom_global_tabs ) != 0 ) :
				$empty_item_style    = 'display:none';
				$collapse_link_style = 'display:block';
			else :
				$empty_item_style    = 'display:block';
				$collapse_link_style = 'display:none';
			endif;
			?>

			<div class="while-empty" style="<?php echo esc_attr( $empty_item_style ); ?>">
				<p>
					<?php esc_html_e( 'Click On "Add New Tab" button to add new Custom Global Tab.', 'wp-travel-pro' ); ?>
				</p>
			</div>
			<div class="wp-collapse-open main-setting" style="<?php echo esc_attr( $collapse_link_style ); ?>" >
				<a href="#" data-parent="wp-travel-tab-content-tabs_global" class="open-all-link"><span class="open-all" id="open-all"><?php esc_html_e( 'Open All', 'wp-travel-pro' ); ?></span></a>
				<a data-parent="wp-travel-tab-content-tabs_global" style="display:none;" href="#" class="close-all-link"><span class="close-all" id="close-all"><?php esc_html_e( 'Close All', 'wp-travel-pro' ); ?></span></a>
			</div>
		</div>
		<div id="tab-accordion" class="tab-accordion main-setting wp-travel-accordion">
			<div class="panel-group wp-travel-sorting-tabs" id="accordion-global-custom-tab" role="tablist" aria-multiselectable="true">
				<?php if ( is_array( $custom_global_tabs ) && count( $custom_global_tabs ) > 0 ) : ?>

					<?php
					foreach ( $custom_global_tabs as $key => $tab ) :

						$show_in_front = isset( $tab['show_in_menu'] ) ? $tab['show_in_menu'] : 'no';

						?>
						<?php $tab['label'] = ( '' !== $tab['label'] ) ? $tab['label'] : __( 'Untitled', 'wp-travel-pro' ); ?>
						<div class="panel panel-default no-sorting">
							<div class="panel-heading" role="tab" id="heading-<?php echo esc_attr( $key ); ?>">
								<h4 class="panel-title">
									<a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion-global-custom-tab" href="#collapse-<?php echo esc_attr( $key ); ?>" aria-expanded="true" aria-controls="collapse-<?php echo esc_attr( $key ); ?>">
										<span class="collapse-icon"></span>

										<span bind="custom_global_tab_<?php echo esc_attr( $key ); ?>" class="faq-label"><?php echo esc_html( $tab['label'] ); ?></span>

									</a>
									<span class="dashicons dashicons-no-alt hover-icon wt-utils-accordion-close"></span>
								</h4>
							</div>
							<div id="collapse-<?php echo esc_attr( $key ); ?>" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading-"<?php echo esc_attr( $key ); ?>>
								<div class="panel-body">
									<div class="panel-wrap">
										<label><?php esc_html_e( 'Tab Label:', 'wp-travel-pro' ); ?></label>
										<input bind="custom_global_tab_<?php echo esc_attr( $key ); ?>" type="text" class="faq-question-text" name="wp_travel_custom_global_tabs[<?php echo esc_attr( $key ); ?>][label]" placeholder="<?php esc_html_e( 'Tab Label', 'wp-travel-pro' ); ?>" value="<?php echo esc_html( $tab['label'] ); ?>">
									</div>
									<div>
										<input value="yes" name="wp_travel_custom_global_tabs[<?php echo esc_attr( $key ); ?>][show_in_menu]" type="hidden" />
									</div>
									<?php

										$custom_tabs_settings = array(
											'quicktags' => array( 'buttons' => 'em,strong,link' ),
											'quicktags' => true,
											'tinymce'   => true,
											'textarea_rows' => 20,
											'editor_height' => 300,
											'textarea_name' => 'wp_travel_custom_global_tabs[' . $key . '][content]',
										);
									?>
									<div class="panel-wrap">
										<label><?php esc_html_e( 'Tab Content:', 'wp-travel-pro' ); ?></label>
										<div class="wp_travel_admin_editor">
											<?php wp_editor( $tab['content'], 'wp_travel_global_custom_tab_cnt_' . $key, $custom_tabs_settings ); ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				<?php endif; ?>
			</div>
		</div>
		<div class="wp-travel-faq-quest-button main-tab-setting clearfix">
			<input id="wp-travel-add-new-tab" type="button" value="<?php esc_html_e( 'Add New Tab', 'wp-travel-pro' ); ?>" class="button button-primary wp-travel-faq-add-new">
		</div>

		<?php
			$tab_label   = __( 'Tab Label', 'wp-travel-pro' );
			$tab_content = __( 'Tab Content', 'wp-travel-pro' );
		?>

		<script type="text/html" id="tmpl-wp-travel-add-new-tab-template">
			<# var content_id = 'wp_travel_global_custom_tab_cnt_' + data.random; #>
			<div class="panel panel-default no-sorting">
				<div class="panel-heading" role="tab" id="heading-{{data.random}}">
					<h4 class="panel-title">
						<a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion-global-custom-tab" href="#collapse-{{data.random}}" aria-expanded="true" aria-controls="collapse-{{data.random}}">

							<span class="collapse-icon"></span>
							<span bind="custom_global_tab_{{data.random}}" class="faq-label"><?php echo esc_html( $tab_label ); ?></span>

						</a>
						<span class="dashicons dashicons-no-alt hover-icon wt-utils-accordion-close"></span>
					</h4>
				</div>
				<div id="collapse-{{data.random}}" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading-"{{data.random}}>
					<div class="panel-body">
						<div class="panel-wrap">
							<label><?php esc_html_e( 'Tab Label:', 'wp-travel-pro' ); ?></label>
							<input bind="custom_global_tab_{{data.random}}" type="text" class="faq-question-text" name="wp_travel_custom_global_tabs[{{data.random}}][label]" placeholder="<?php esc_html_e( 'Tab Label', 'wp-travel-pro' ); ?>" value="">
						</div>
						<div>
							<input value="yes" name="wp_travel_custom_global_tabs[{{data.random}}][show_in_menu]" id="hide_related_itinerary" type="hidden" />
						</div>
							<p class="description"></p>
					</div>
					<div class="panel-wrap">
						<label><?php esc_html_e( 'Tab Content:', 'wp-travel-pro' ); ?></label>
						<div class="wp_travel_admin_editor">
							<textarea name="wp_travel_custom_global_tabs[{{data.random}}][content]" id="{{content_id}}" rows="10"></textarea>
						</div>
					</div>

				</div>
			</div>
		</script>
	<?php

}

/**
 * FAQs Global Tabs Callback.
 */
function wp_travel_utilities_global_faq_tab_callback( $tab, $args ) {


	$wp_travel_utils_global_faq_question = isset( $args['settings']['wp_travel_utils_global_faq_question'] ) ? $args['settings']['wp_travel_utils_global_faq_question'] : array();

	$custom_global_utils_faq = isset( $args['settings']['wp_travel_utils_global_faq_answer'] ) ? $args['settings']['wp_travel_utils_global_faq_answer'] : array();

	?>
	<div id="wp-travel-global-faq">
		<input type="hidden" name="wp_travel_utils_global_faq_question">
		<input type="hidden" name="wp_travel_utils_global_faq_answer">
		<div class="wp-travel-tab-content-faq-header clearfix">
			<?php
			if ( is_array( $wp_travel_utils_global_faq_question ) && count( $wp_travel_utils_global_faq_question ) != 0 ) :
				$empty_item_style    = 'display:none';
				$collapse_link_style = 'display:block';
				else :
					$empty_item_style    = 'display:block';
					$collapse_link_style = 'display:none';
				endif;
				?>
	
			<div class="while-empty" style="<?php echo esc_attr( $empty_item_style ); ?>">
				<p>
					<?php esc_html_e( 'Click On "Add New Question" button to add new FAQ question.', 'wp-travel-pro' ); ?>
				</p>
			</div>
			<div style="<?php echo esc_attr( $collapse_link_style ); ?>" class="wp-travel-utils-global-faq-shortcode">
				<p>
					<?php esc_html_e( 'Use the shortcode below to display the global FAQs data.', 'wp-travel-pro' ); ?>
				</p>
				<p>
					<input id="wp-travel-utils-global-faq-shortcode" readonly cols="30" rows="3" value="<?php echo esc_html( '[wp_travel_utils_global_faq]' ); ?>" type="text" />
				</p>
			</div>
			<div class="wp-collapse-open main-setting" style="<?php echo esc_attr( $collapse_link_style ); ?>" >
				<a href="#" data-parent="wp-travel-global-faq" class="open-all-link"><span class="open-all" id="open-all"><?php esc_html_e( 'Open All', 'wp-travel-pro' ); ?></span></a>
				<a data-parent="wp-travel-global-faq" style="display:none;" href="#" class="close-all-link"><span class="close-all" id="close-all"><?php esc_html_e( 'Close All', 'wp-travel-pro' ); ?></span></a>
			</div>
		</div>
		<div id="wt-utils-global-faq-data" class="tab-accordion main-setting wp-travel-accordion has-handler">
			<div class="panel-group wp-travel-sorting-tabs" id="wp-travel-utils-global-content-faq" role="tablist" aria-multiselectable="true">
	
				<?php if ( is_array( $wp_travel_utils_global_faq_question ) && 0 !== count( $wp_travel_utils_global_faq_question ) ) : ?>
					<?php foreach ( $wp_travel_utils_global_faq_question as $key => $question ) : ?>
						<div class="panel panel-default">
							<div class="panel-heading" role="tab" id="heading-<?php echo esc_attr( $key ); ?>">
								<h4 class="panel-title">
									<div class="wp-travel-sorting-handle"></div>
									<a role="button" data-toggle="collapse" data-parent="#accordion-faq-data" href="#collapse-<?php echo esc_attr( $key ); ?>" aria-expanded="true" aria-controls="collapse-<?php echo esc_attr( $key ); ?>">
	
										<span bind="wp_travel_utils_global_faq_question_<?php echo esc_attr( $key ); ?>"><?php echo $question ? esc_html( $question ) : esc_html__( '[UNTITLED]', 'wp-travel-pro' ); ?></span>
	
									<!-- <span class="collapse-icon"></span> -->
									</a>
									<span class="dashicons dashicons-no-alt hover-icon wt-utils-accordion-close"></span>
								</h4>
							</div>
							<div id="collapse-<?php echo esc_attr( $key ); ?>" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading-<?php echo esc_attr( $key ); ?>">
								<div class="panel-body">
									<div class="panel-wrap">
										<label><?php esc_html_e( 'Enter Your Question', 'wp-travel-pro' ); ?></label>
										<input bind="wp_travel_utils_global_faq_question_<?php echo esc_attr( $key ); ?>" type="text" name="wp_travel_utils_global_faq_question[]" placeholder="<?php esc_html_e( 'FAQ Question?', 'wp-travel-pro' ); ?>" class="faq-question-text" value="<?php echo esc_html( $question ); ?>">
									</div>
									<textarea rows="6" name="wp_travel_utils_global_faq_answer[]" placeholder="Write Your Answer."><?php echo esc_html( $custom_global_utils_faq[ $key ] ); ?></textarea>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				<?php endif; ?>
	
	
			</div>
			<div class="wp-travel-faq-quest-button main-tab-setting clearfix">
				<input id="wp-travel-add-new-global-faq" type="button" value="<?php esc_html_e( 'Add New Question', 'wp-travel-pro' ); ?>" class="button button-primary wp-travel-faq-add-new">
			</div>
			<script type="text/html" id="tmpl-wp-travel-utilities-global-faqs">
				<div class="panel panel-default">
					<div class="panel-heading" role="tab" id="heading-{{data.random}}">
						<h4 class="panel-title">
							<div class="wp-travel-sorting-handle"></div>
							<a role="button" data-toggle="collapse" data-parent="#accordion-faq-data" href="#collapse-{{data.random}}" aria-expanded="true" aria-controls="collapse-{{data.random}}">
	
								<span bind="wp_travel_utils_global_faq_question_{{data.random}}"><?php echo esc_html( 'FAQ?', 'wp-travel' ); ?></span>
	
							<!-- <span class="collapse-icon"></span> -->
							</a>
							<span class="dashicons dashicons-no-alt hover-icon wt-utils-accordion-close"></span>
						</h4>
					</div>
					<div id="collapse-{{data.random}}" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="heading-{{data.random}}">
						<div class="panel-body">
							<div class="panel-wrap">
								<label><?php esc_html_e( 'Enter Your Question', 'wp-travel-pro' ); ?></label>
								<input bind="wp_travel_utils_global_faq_question_{{data.random}}" type="text" name="wp_travel_utils_global_faq_question[]" placeholder="<?php esc_html_e( 'FAQ Question?', 'wp-travel-pro' ); ?>" class="faq-question-text" value="">
							</div>
							<textarea rows="6" name="wp_travel_utils_global_faq_answer[]" placeholder="Write Your Answer."></textarea>
						</div>
					</div>
				</div>
			</script>
		</div>
	</div>

	<?php

}

// Add settings to the save settings Array.
add_filter( 'wp_travel_before_save_settings', 'wp_travel_save_utilities_settings_array' );

/**
 * Wp_travel_save_utilities_settings_array Save Additional Settings.
 *
 * @param array $settings_array settings array.
 */
function wp_travel_save_utilities_settings_array( $settings_array ) {

	$enable_custom_trip_code_option                   = ( isset( $_POST['enable_custom_trip_code_option'] ) && '' !== $_POST['enable_custom_trip_code_option'] ) ? 'yes' : 'no';
	$settings_array['enable_custom_trip_code_option'] = $enable_custom_trip_code_option;

	$disable_email_powered_by_text                   = ( isset( $_POST['disable_email_powered_by_text'] ) && '' !== $_POST['disable_email_powered_by_text'] ) ? 'yes' : 'no';
	$settings_array['disable_email_powered_by_text'] = $disable_email_powered_by_text;

	if ( isset( $_POST['email_template_powered_by_text'] ) && ! empty( $_POST['email_template_powered_by_text'] ) ) {

		$settings_array['email_template_powered_by_text'] = wp_kses_post( wp_unslash( $_POST['email_template_powered_by_text'] ) );

	}
	// Save Booking Notification E-mails.
	if ( isset( $_POST['wp_travel_booking_notif_emails'] ) ) {

		$booking_emails = $_POST['wp_travel_booking_notif_emails'];

		if ( is_array( $_POST['wp_travel_booking_notif_emails'] ) ) {

			$booking_emails = array_filter( $booking_emails, 'is_email' );
		}

		$settings_array['wp_travel_booking_notif_emails'] = stripslashes_deep( $booking_emails );

	}
	// Save Payment Notification E-mails.
	if ( isset( $_POST['wp_travel_payment_notif_emails'] ) ) {

		$payment_emails = $_POST['wp_travel_payment_notif_emails'];

		if ( is_array( $_POST['wp_travel_payment_notif_emails'] ) ) {

			$payment_emails = array_filter( $payment_emails, 'is_email' );
		}

		$settings_array['wp_travel_payment_notif_emails'] = stripslashes_deep( $payment_emails );

	}
	// Save Enquiries Notification E-mails.
	if ( isset( $_POST['wp_travel_enquiry_notif_emails'] ) && ! empty( $_POST['wp_travel_enquiry_notif_emails'] ) ) {

		$enquiry_emails = $_POST['wp_travel_enquiry_notif_emails'];

		if ( is_array( $_POST['wp_travel_enquiry_notif_emails'] ) ) {

			$enquiry_emails = array_filter( $enquiry_emails, 'is_email' );
		}

		$settings_array['wp_travel_enquiry_notif_emails'] = stripslashes_deep( $enquiry_emails );

	}

	// Save Custom global tabs
	$valid_custom_global_tabs = array();
	// error_log( print_r( $settings_array, true ) );
	if ( isset( $_POST['wp_travel_custom_global_tabs'] ) && is_array( $_POST['wp_travel_custom_global_tabs'] ) ) {
		$global_tab_settings = $_POST['wp_travel_custom_global_tabs'];
		$custom_tabs_data = $_POST['wp_travel_custom_global_tabs'];

		foreach ( $custom_tabs_data as $key => $tab ) {
			// Dont Save Empty Tabs.
			if ( ! empty( $tab['label'] ) ) {

				$tab['custom'] = 'yes';
				$tab['global'] = 'yes';

				$valid_custom_global_tabs[ wp_travel_utilities_slugify_string( $tab['label'] ) ] = $tab;

				if ( false === array_search( $tab['label'], wp_list_pluck( $global_tab_settings, 'label' ) ) ) {

					$global_tab_settings[ wp_travel_utilities_slugify_string( $tab['label'] ) ] = $tab;

				}
			}
		}
		$settings_array['wp_travel_custom_global_tabs'] = stripslashes_deep( $valid_custom_global_tabs );
	}
	
	// Save Global FAQ Questions.
	if ( isset( $_POST['wp_travel_utils_global_faq_question'] ) ) {

		$wp_travel_utils_global_faq_question = ( wp_unslash( $_POST['wp_travel_utils_global_faq_question'] ) );

		$settings_array['wp_travel_utils_global_faq_question'] = $wp_travel_utils_global_faq_question;
	}

	if ( isset( $_POST['wp_travel_utils_global_faq_answer'] ) ) {

		$wp_travel_utils_global_faq_answer = ( wp_unslash( $_POST['wp_travel_utils_global_faq_answer'] ) );

		$settings_array['wp_travel_utils_global_faq_answer'] = $wp_travel_utils_global_faq_answer;
	}

	return $settings_array;

}

// Tab trip page.
function wp_travel_utilities_itinerary_custom_tab_callback( $post_id = null ) {
	if ( is_null( $post_id ) ) {
		global $post;
		$post_id = $post->ID;
	}

	$custom_itinerary_tabs = get_post_meta( $post_id, 'wp_travel_itinerary_custom_tab_cnt_', true );
	?>
	<div id="wp-travel-custom-itineray-tab-content" class="wp-travel-tab-content-faq-header clearfix">
		<?php
		if ( is_array( $custom_itinerary_tabs ) && count( $custom_itinerary_tabs ) != 0 ) :
			$empty_item_style    = 'display:none';
			$collapse_link_style = 'display:block';
		else :
			$empty_item_style    = 'display:block';
			$collapse_link_style = 'display:none';
		endif;
		?>

		<div class="while-empty" style="<?php echo esc_attr( $empty_item_style ); ?>">
			<p>
				<?php esc_html_e( 'Click On "Add New Tab" button to add new Custom Itinerary Tab.', 'wp-travel-pro' ); ?>
			</p>
		</div>
		<div class="wp-collapse-open main-setting" style="<?php echo esc_attr( $collapse_link_style ); ?>" >
			<a href="#" data-parent="itinerary-customtab-accordion" class="open-all-link"><span class="open-all" id="open-all"><?php esc_html_e( 'Open All', 'wp-travel-pro' ); ?></span></a>
			<a data-parent="itinerary-customtab-accordion" style="display:none;" href="#" class="close-all-link"><span class="close-all" id="close-all"><?php esc_html_e( 'Close All', 'wp-travel-pro' ); ?></span></a>
		</div>
	</div>
	<div id="itinerary-customtab-accordion" class="tab-accordion main-setting wp-travel-accordion">
		<div class="panel-group" id="accordion-itinerary-custom-tab" role="tablist" aria-multiselectable="true">
			<?php if ( is_array( $custom_itinerary_tabs ) && count( $custom_itinerary_tabs ) > 0 ) : ?>

				<?php
				foreach ( $custom_itinerary_tabs as $key => $tab ) :
					if ( ! is_array( $tab ) ) {
						$tab = ( array ) $tab; // @todo need to reset tab.
					}
					$show_in_front = isset( $tab['show_in_menu'] ) ? $tab['show_in_menu'] : 'no';

					?>
					<?php $tab['label'] = ( '' !== $tab['label'] ) ? $tab['label'] : __( 'Untitled', 'wp-travel-pro' ); ?>
					<div class="panel panel-default no-sorting">
						<div class="panel-heading" role="tab" id="heading-<?php echo esc_attr( $key ); ?>">
							<h4 class="panel-title">
								<a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion-itinerary-custom-tab" href="#collapse-<?php echo esc_attr( $key ); ?>" aria-expanded="true" aria-controls="collapse-<?php echo esc_attr( $key ); ?>">

									<span bind="custom_itinerary_tab_<?php echo esc_attr( $key ); ?>" class="faq-label"><?php echo esc_html( $tab['label'] ); ?></span>

								<span class="collapse-icon"></span>
								</a>
								<span class="dashicons dashicons-no-alt hover-icon wt-utils-accordion-close"></span>
							</h4>
						</div>
						<div id="collapse-<?php echo esc_attr( $key ); ?>" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading-"<?php echo esc_attr( $key ); ?>>
							<div class="panel-body">
								<div class="panel-wrap">
									<label><?php esc_html_e( 'Tab Label:', 'wp-travel-pro' ); ?></label>
									<input bind="custom_itinerary_tab_<?php echo esc_attr( $key ); ?>" type="text" class="faq-question-text" name="wp_travel_itinerary_custom_tab_cnt_[<?php echo esc_attr( $key ); ?>][label]" placeholder="<?php esc_html_e( 'Tab Label', 'wp-travel-pro' ); ?>" value="<?php echo esc_html( $tab['label'] ); ?>">
								</div>
								<div>
									<input value="yes" name="wp_travel_itinerary_custom_tab_cnt_[<?php echo esc_attr( $key ); ?>][show_in_menu]" type="hidden" />
								</div>
								<?php

									$custom_tabs_settings = array(
										'quicktags' => array( 'buttons' => 'em,strong,link' ),
										'quicktags' => true,
										'tinymce'   => true,
										'textarea_rows' => 20,
										'editor_height' => 300,
										'textarea_name' => 'wp_travel_itinerary_custom_tab_cnt_[' . $key . '][content]',
									);
								?>
								<div class="panel-wrap">
									<label><?php esc_html_e( 'Tab Content:', 'wp-travel-pro' ); ?></label>
									<div class="wp_travel_admin_editor">
										<?php wp_editor( $tab['content'], 'wp_travel_global_custom_tab_cnt_' . $key, $custom_tabs_settings ); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php endforeach; ?>
			<?php endif; ?>
		</div>
	</div>
	<div class="wp-travel-faq-quest-button main-tab-setting clearfix">
		<input id="wp-travel-add-new-itinerary-tab" type="button" value="<?php esc_html_e( 'Add New Tab', 'wp-travel-pro' ); ?>" class="button button-primary">
	</div>

	<?php
		$tab_label   = __( 'Tab Label', 'wp-travel-pro' );
		$tab_content = __( 'Tab Content', 'wp-travel-pro' );
	?>

	<script type="text/html" id="tmpl-wp-travel-add-new-itinerary-tab-template">
		<# var content_id = 'wp_travel_itinerary_custom_tab_cnt_' + data.random; #>
		<div class="panel panel-default no-sorting">
			<div class="panel-heading" role="tab" id="heading-{{data.random}}">
				<h4 class="panel-title">
					<a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion-itinerary-custom-tab" href="#collapse-{{data.random}}" aria-expanded="true" aria-controls="collapse-{{data.random}}">

						<span bind="custom_itinerary_tab_{{data.random}}" class="faq-label"><?php echo esc_html( $tab_label ); ?></span>

					<span class="collapse-icon"></span>
					</a>
					<span class="dashicons dashicons-no-alt hover-icon wt-utils-accordion-close"></span>
				</h4>
			</div>
			<div id="collapse-{{data.random}}" class="panel-collapse collapse" role="tabpanel" aria-labelledby="heading-{{data.random}}">
				<div class="panel-body">
					<div class="panel-wrap">
						<label><?php esc_html_e( 'Tab Label:', 'wp-travel-pro' ); ?></label>
						<input bind="custom_itinerary_tab_{{data.random}}" type="text" class="faq-question-text" name="wp_travel_itinerary_custom_tab_cnt_[{{data.random}}][label]" placeholder="<?php esc_html_e( 'Tab Label', 'wp-travel-pro' ); ?>" value="">
					</div>
					<div>
						<input value="yes" name="wp_travel_itinerary_custom_tab_cnt_[{{data.random}}][show_in_menu]" id="hide_related_itinerary" type="hidden" />
					</div>
						<p class="description"></p>
				</div>
				<div class="panel-wrap">
					<label><?php esc_html_e( 'Tab Content:', 'wp-travel-pro' ); ?></label>
					<div class="wp_travel_admin_editor">
						<textarea name="wp_travel_itinerary_custom_tab_cnt_[{{data.random}}][content]" id="{{content_id}}" rows="10"></textarea>
					</div>
				</div>

			</div>
		</div>
	</script>
	<?php

}

/**
 * USE Global FAQ Options.
 */
function wp_travel_utils_itinerary_global_faq() {

	global $post;

	$post_id = $post->ID;

	$use_global_faqs = get_post_meta( $post_id, 'wp_travel_utils_use_global_faq_for_trip', true );
	$use_global_faqs = ( $use_global_faqs ) ? $use_global_faqs : 'no';

	$use_trip_faqs = get_post_meta( $post_id, 'wp_travel_utils_use_trip_faq_for_trip', true );
	$use_trip_faqs = ( $use_trip_faqs ) ? $use_trip_faqs : 'no';
	
	?>

	<table class="form-table">
		<tr>
			<th>
				<label for="currency"><?php echo esc_html__( 'Use Global FAQs', 'wp-travel-pro' ); ?></label>
			</th>
			<td>
				<span class="show-in-frontend checkbox-default-design">
					<label data-on="ON" data-off="OFF">
						<input <?php checked( $use_global_faqs, 'yes' ); ?> value="yes" name="wp_travel_utils_use_global_faq_for_trip" id="wp_travel_utils_use_global_faq_for_trip" type="checkbox" />
						<span class="switch">
						</span>
					</label>
				</span>
				<p class="description"><label for="wp_travel_utils_use_global_faq_for_trip"><?php echo esc_html__( 'Check to use Global FAQ for the trip.', 'wp-travel-pro' ); ?></label></p>
			</td>
		</tr>
		<tr>
			<th>
				<label for="currency"><?php echo esc_html__( 'Use Trip FAQs', 'wp-travel-pro' ); ?></label>
			</th>
			<td>
				<span class="show-in-frontend checkbox-default-design">
					<label data-on="ON" data-off="OFF">
						<input <?php checked( $use_trip_faqs, 'yes' ); ?> value="yes" name="wp_travel_utils_use_trip_faq_for_trip" id="wp_travel_utils_use_trip_faq_for_trip" type="checkbox" />
						<span class="switch">
						</span>
					</label>
				</span>
				<p class="description"><label for="wp_travel_utils_use_trip_faq_for_trip"><?php echo esc_html__( 'Check to use Trip FAQ along with Global for the trip.', 'wp-travel-pro' ); ?></label></p>
			</td>
		</tr>
	</table>
	<?php

}


add_action( 'wp_travel_utils_booking_notif', 'wp_travel_utils_booking_notif_emails' );

function wp_travel_utils_booking_notif_emails() {

	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}

	$booking_notif_emails = isset( $settings['wp_travel_booking_notif_emails'] ) ? $settings['wp_travel_booking_notif_emails'] : array();

	echo '<tr>';
		echo '<th>';
			echo '<label for="currency">' . esc_html__( 'To Emails', 'wp-travel-pro' ) . '</label>';
		echo '</th>';
		echo '<td>';
			echo '<div class="booking-emails">';
				echo '<input value=""  name="wp_travel_booking_notif_emails" class="notif-email-field"  placeholder="' . esc_attr( 'Enter an E-mail and press "Add"', 'wp-travel' ) . '" autocomplete="off" type="text"/>';
				echo '<span class="option-adder button button-primary">Add</span>';
				echo '<div class="options-holder">';
	if ( is_array( $booking_notif_emails ) && ! empty( $booking_notif_emails ) ) {

		foreach ( $booking_notif_emails as $key => $email ) {
			echo '<p>' . esc_html( $email ) . '<input type="hidden" name="wp_travel_booking_notif_emails[' . esc_attr( $key ) . ']" value="' . esc_attr( $email ) . '"/><span class="option-deleter"><span class="dashicons dashicons-no-alt"></span></span></p>';
		}
	}
				echo '</div>';

			echo '</div>';
		echo '</td>';
	echo '</tr>';

}

add_action( 'wp_travel_utils_payment_notif', 'wp_travel_utils_payment_notif_emails' );

function wp_travel_utils_payment_notif_emails() {

	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}

	$payment_notif_emails = isset( $settings['wp_travel_payment_notif_emails'] ) ? $settings['wp_travel_payment_notif_emails'] : array();

	echo '<tr>';
			echo '<th>';
				echo '<label for="currency">' . esc_html__( 'To Emails', 'wp-travel-pro' ) . '</label>';
			echo '</th>';
			echo '<td>';
				echo '<div class="booking-emails">';
					echo '<input value=""  name="wp_travel_payment_notif_emails" class="notif-email-field"  placeholder="' . esc_attr( 'Enter an E-mail and press "Add"', 'wp-travel' ) . '" type="text" autocomplete="off"/>';
					echo '<span class="option-adder button button-primary">Add</span>';
					echo '<div class="options-holder">';
	if ( is_array( $payment_notif_emails ) && ! empty( $payment_notif_emails ) ) {

		foreach ( $payment_notif_emails as $key => $email ) {
			echo '<p>' . esc_html( $email ) . '<input type="hidden" name="wp_travel_payment_notif_emails[' . esc_attr( $key ) . ']" value="' . esc_attr( $email ) . '"/><span class="option-deleter"><span class="dashicons dashicons-no-alt"></span></span></p>';
		}
	}
					echo '</div>';
				echo '</div>';
			echo '</td>';
	echo '</tr>';

}

add_action( 'wp_travel_utils_enquiries_notif', 'wp_travel_utils_enquiries_notif_emails' );

function wp_travel_utils_enquiries_notif_emails() {

	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}

	$enquery_notif_emails = isset( $settings['wp_travel_enquiry_notif_emails'] ) ? $settings['wp_travel_enquiry_notif_emails'] : array();

	echo '<tr>';
			echo '<th>';
				echo '<label for="currency">' . esc_html__( 'To Emails', 'wp-travel-pro' ) . '</label>';
			echo '</th>';
			echo '<td>';
				echo '<div class="booking-emails">';
					echo '<input value=""  name="wp_travel_enquiry_notif_emails" class="notif-email-field"  placeholder="' . esc_attr( 'Enter an E-mail and press "Add"', 'wp-travel' ) . '" type="text" autocomplete="off"/>';
					echo '<span class="option-adder button button-primary button button-primary">Add</span>';
					echo '<div class="options-holder">';
	if ( is_array( $enquery_notif_emails ) && ! empty( $enquery_notif_emails ) ) {

		foreach ( $enquery_notif_emails as $key => $email ) {
			echo '<p>' . esc_html( $email ) . '<input type="hidden" name="wp_travel_enquiry_notif_emails[' . esc_attr( $key ) . ']" value="' . esc_attr( $email ) . '"/><span class="option-deleter"><span class="dashicons dashicons-no-alt"></span></span></p>';
		}
	}
					echo '</div>';
				echo '</div>';
			echo '</td>';
		echo '</tr>';

}

/**
 * Display Custom Trip code in Trip tab.
 *
 * @param   array $args tab arguments along with settings.
 *
 * @return void
 */
function wp_travel_utils_trip_tab_content( $args ) {
	$enable_custom_trip_code_option = isset( $args['settings']['enable_custom_trip_code_option'] ) ? $args['settings']['enable_custom_trip_code_option'] : 'yes';
	echo '<table class="form-table">';
	echo '<tr>';
		echo '<th>';
			echo '<label for="currency">' . esc_html__( 'Custom Trip Codes', 'wp-travel-pro' ) . '</label>';
		echo '</th>';
		echo '<td>';
			echo '<span class="show-in-frontend checkbox-default-design">';
				echo '<label data-on="ON" data-off="OFF">';
					echo '<input' . checked( $enable_custom_trip_code_option, 'yes', false ) . ' value="yes" name="enable_custom_trip_code_option" id="enable_custom_trip_code_option" type="checkbox" />';
					echo '<span class="switch">';
					echo '</span>';
				echo '</label>';
			echo '</span>';
			echo '<p class="description"><label for="enable_custom_trip_code_option">' . esc_html__( 'Enable Custom Trip Code Support for Trips', 'wp-travel-pro' ) . '</label></p>';
		echo '</td>';
	echo '</tr>';
	echo '</table>';
}
add_action( 'wp_travel_tab_content_before_trips', 'wp_travel_utils_trip_tab_content' );

function wp_travel_thankyou_page_settings( $tab, $args ) {
	$thank_you_page = isset( $args['settings']['thank_you_page_id'] ) ? $args['settings']['thank_you_page_id'] : wptravel_get_page_id( 'booking-thank-you' );

	?>
	<tr>
		<th><label for="checkout-page-id"><?php echo esc_html__( 'Thank You Page', 'wp-travel-pro' ); ?></label></th>
		<td>
			<?php
			wp_dropdown_pages(
				array(
					'depth'                 => 0,
					'child_of'              => 0,
					'selected'              => esc_html( $thank_you_page ),
					'echo'                  => 1,
					'name'                  => 'thank_you_page_id',
					'id'                    => 'thank-you-page-id', // string
					'class'                 => 'wp-travel-select2', // string
					'show_option_none'      => null, // string
					'show_option_no_change' => null, // string
					'option_none_value'     => null, // string
				)
			);
			?>
			<p class="description"><?php echo esc_html__( 'Choose the page to use as checkout page which contents thankyou page shortcode [wp_travel_thankyou].', 'wp-travel-pro' ); ?></p>
		</td>
	<tr>
	<?php
}

add_action( 'wp_travel_after_page_settings', 'wp_travel_thankyou_page_settings', 10, 2 );
