<?php
/**
 * Email Template Additional Options.
 *
 * @package WP_Travel_Utilities
 */
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WP_Travel_Util_Custom_Email_Template_Options Class.
 */
class WP_Travel_Util_Custom_Email_Template_Options {

	/**
	 * Constructor WP_Travel_Util_Custom_Email_Template_Options.
	 */
	public function __construct() {

		$this->init_hooks();

	}
	/**
	 * Init hooks
	 */
	public function init_hooks() {

		if ( $this->disable_footer_copyright() ) {

			add_filter( 'wp_travel_disable_email_template_poweredby', '__return_true' );

		} else {

			add_filter( 'wp_travel_email_template_footer_text', array( $this, 'override_email_footer' ) );
		}

		add_filter( 'wp_travel_booking_admin_emails', array( $this, 'overrride_booking_admin_emails' ) );

		add_filter( 'wp_travel_payments_admin_emails', array( $this, 'overrride_payment_admin_emails' ) );

		add_filter( 'wp_travel_enquiries_admin_emails', array( $this, 'overrride_enquiries_admin_emails' ) );

	}
	/**
	 * Disabled Footer Powered By
	 */
	public function disable_footer_copyright(){

		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings();
		}

		$disble_pwr_by = isset( $settings['disable_email_powered_by_text'] ) ? $settings['disable_email_powered_by_text'] : 'no';

		if ( 'yes' === $disble_pwr_by ) {

			return true;

		} else {

			return false;

		}

	}
	/**
	 * Overwrite Email Footer
	 */
	public function override_email_footer() {

		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings();
		}

		$footer_powered_by_text = isset( $settings['email_template_powered_by_text'] ) ? $settings['email_template_powered_by_text'] : __( '{sitename} - Powered By: ', 'wp-travel-pro' ) . '<a href="http://wptravel.io/" target="_blank" style="color: #5a418b;text-decoration: none;">WP Travel.</a>';

		


		if( function_exists( 'wptravel_custom_email_template_content' ) ){
			$lang_attribute = get_bloginfo('language');
			if( array_key_exists( $lang_attribute, wptravel_custom_email_template_content() ) ){
				if( array_key_exists( 'email_template_powered_by_text', wptravel_custom_email_template_content()[$lang_attribute] ) ){
					$footer_powered_by_text = wptravel_custom_email_template_content()[$lang_attribute]['email_template_powered_by_text'];
				}
			}
			
		}

		return $footer_powered_by_text;

	}
	/**
	 * Override Booking Emails.
	 */
	public function overrride_booking_admin_emails( $admin_email ) {

		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings();
		}

		$saved_bk_emails = isset( $settings['wp_travel_booking_notif_emails'] ) && ! empty( $settings['wp_travel_booking_notif_emails'] ) ? $settings['wp_travel_booking_notif_emails'] : array();

		if ( is_array( $saved_bk_emails ) && ! empty( $saved_bk_emails ) ) {

			$admin_email = $saved_bk_emails;

		}

		return $admin_email;

	}
	/**
	 * Override Payment Emails.
	 */
	public function overrride_payment_admin_emails( $admin_email ) {

		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings();
		}

		$saved_pmt_emails = isset( $settings['wp_travel_payment_notif_emails'] ) && ! empty( $settings['wp_travel_payment_notif_emails'] ) ? $settings['wp_travel_payment_notif_emails'] : array();

		if ( is_array( $saved_pmt_emails ) && ! empty( $saved_pmt_emails ) ) {

			$admin_email = $saved_pmt_emails;

		}

		return $admin_email;
		
	}
	/**
	 * Override Enquiries Emails.
	 */
	public function overrride_enquiries_admin_emails( $admin_email ) {

		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings();
		}

		$saved_enq_emails = isset( $settings['wp_travel_enquiry_notif_emails'] ) && ! empty( $settings['wp_travel_enquiry_notif_emails'] ) ? $settings['wp_travel_enquiry_notif_emails'] : array();

		if ( is_array( $saved_enq_emails ) && ! empty( $saved_enq_emails ) ) {

			$admin_email = $saved_enq_emails;

		}

		return $admin_email;
		
	}

}

new WP_Travel_Util_Custom_Email_Template_Options();
