<?php

// Backend

// Add Time in pricing
add_action( 'wp_travel_price_tab_after_multiple_date', 'wp_travel_pricing_time_admin_fields', 20, 2 );
add_action( 'wp_travel_price_tab_after_multiple_date_template', 'wp_travel_pricing_time_admin_fields_repeator' );


// Save Time meta
add_action( 'wp_travel_itinerary_extra_meta_save', 'wp_travel_pricing_time_save_admin_fields', 20 );


if ( ! function_exists( 'wp_travel_pricing_time_admin_fields' ) ) {
	function wp_travel_pricing_time_admin_fields( $trip_id, $date_id ) {

		if ( ! $trip_id ) {
			return;
		}

		if ( ! $date_id ) {
			return;
		}

		$trip_times = get_post_meta( $trip_id, 'wp_travel_trip_time', true );
		
		$trip_time = is_array( $trip_times ) && isset( $trip_times[ $date_id ] ) ? $trip_times[ $date_id ] : array();
		
		$enable_trip_time = isset( $trip_time['enable_trip_time'] ) && 'yes' === $trip_time['enable_trip_time'] ? 'yes' : 'no';
		$times            = isset( $trip_time['times'] ) ? $trip_time['times'] : array();
		?>
		<div class="wp-travel-trip-time" style="padding:15px">
			<div class="repeat-row">
				<label class="one-third" for="enable_trip_time"><?php esc_html_e( 'Enable Time', 'wp-travel-pro' ); ?></label>
				<div class="two-third">
					<span class="show-in-frontend checkbox-default-design">
						<label data-on="ON" data-off="OFF">
							<input class="enable_trip_time" name="wp_travel_trip_time[<?php echo esc_attr( $date_id ); ?>][enable_trip_time]" type="checkbox" value="yes" <?php checked( 'yes', $enable_trip_time ); ?> >
							<span class="switch"></span>
						</label>
					</span>
					<div class="wp-travel-time-picker-wrapper <?php echo 'yes' === $enable_trip_time ? '' : esc_attr( 'hidden' ); ?>">
						<input type="text"  class="wp-travel-timepicker" placeholder="Click on '+' to add" >
						<a href="" class="wp-travel-add-new-time" data-pricing-id="<?php echo esc_attr( $date_id ); ?>"  >+</a>
					</div>

				</div>
			</div>
			<div class="repeat-row wp-travel-trip-time-row <?php echo 'yes' === $enable_trip_time ? '' : esc_attr( 'hidden' ); ?>">
				<label class="one-third" for=""><?php esc_html_e( 'Time', 'wp-travel-pro' ); ?></label>
				<div class="two-third wp-travel-time-input">
					<?php
					$has_time = false;
					if ( is_array( $times ) && count( $times ) > 0 ) {
						$has_time = true;
						foreach ( $times as $time ) {
							?>
							<div class="timepicker-input">
								<span><?php echo esc_html( $time ); ?> </span>
								<a href="#" class="timepicker-close close">x</a>
								<input type="hidden" value="<?php echo esc_html( $time ); ?>" class="wp-travel-trip-time" name="wp_travel_trip_time[<?php echo esc_attr( $date_id ); ?>][times][]" >
							</div>
							<?php
						}
					}
					?>
					<p class="wp-travel-no-trip-time <?php echo $has_time ? esc_attr( 'hidden' ) : ''; ?> " ><?php echo esc_html( 'Please add time.' ); ?></p>

				</div>

			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'wp_travel_pricing_time_save_admin_fields' ) ) {
	function wp_travel_pricing_time_save_admin_fields( $trip_id ) {
		if ( ! $trip_id ) {
			return;
		}

		if ( isset( $_POST['wp_travel_trip_time'] ) ) {
			$wp_travel_trip_time = $_POST['wp_travel_trip_time'];
			update_post_meta( $trip_id, 'wp_travel_trip_time', $wp_travel_trip_time );
		}
	}
}

// Just a repeator.
function wp_travel_pricing_time_admin_fields_repeator( $post_id ) {

		$date_id = '{{data.random}}';
		
		$enable_trip_time = 'no';
		$times            = array();
		?>
		<div class="wp-travel-trip-time" style="padding:15px">
			<div class="repeat-row">
				<label class="one-third" for="enable_trip_time"><?php esc_html_e( 'Enable Time', 'wp-travel-pro' ); ?></label>
				<div class="two-third">
					<span class="show-in-frontend checkbox-default-design">
						<label data-on="ON" data-off="OFF">
							<input class="enable_trip_time" name="wp_travel_trip_time[<?php echo esc_attr( $date_id ); ?>][enable_trip_time]" type="checkbox" value="yes" <?php checked( 'yes', $enable_trip_time ); ?> >
							<span class="switch"></span>
						</label>
					</span>
					<div class="wp-travel-time-picker-wrapper <?php echo 'yes' === $enable_trip_time ? '' : esc_attr( 'hidden' ); ?>">
						<input type="text"  class="wp-travel-timepicker" placeholder="Click on '+' to add" >
						<a href="" class="wp-travel-add-new-time" data-pricing-id="<?php echo esc_attr( $date_id ); ?>" >+</a>
					</div>

				</div>
			</div>
			<div class="repeat-row wp-travel-trip-time-row <?php echo 'yes' === $enable_trip_time ? '' : esc_attr( 'hidden' ); ?>">
				<label class="one-third" for=""><?php esc_html_e( 'Time', 'wp-travel-pro' ); ?></label>
				<div class="two-third wp-travel-time-input">
					<?php $has_time = false; ?>
					<p class="wp-travel-no-trip-time <?php echo $has_time ? esc_attr( 'hidden' ) : ''; ?> " ><?php echo esc_html( 'Please add time.' ); ?></p>
				</div>

			</div>
		</div>
	<?php
}
function wp_travel_show_booking_trip_time( $date, $order_detail ) {

	if ( isset( $order_detail['trip_time'] ) && ! empty( $order_detail['trip_time'] ) ) {
		$date .= ' ' . $order_detail['trip_time'];
	}
	return $date;

}
add_filter( 'wp_travel_booking_travel_date', 'wp_travel_show_booking_trip_time', 10, 2  );


// Frontend.

add_action( 'wp_travel_action_after_itinerary_date', 'wp_travel_trip_time_frontend', 10, 2 );
add_action( 'wp_travel_action_additional_pricing_attributes', 'wp_travel_trip_time_frontend_attrs' );

add_filter( 'wp_travel_cart_attributes', 'wp_travel_trip_time_cart_attributes' );
add_action( 'wp_travel_action_cart_after_date', 'wp_travel_trip_time_cart_page', 10, 2 );

// Backend Booking detail page
add_action( 'wp_travel_after_bookings_travel_date', 'wp_travel_trip_time_booking_detail_page', 11 );

function wp_travel_trip_time_frontend( $trip_id, $pricing ) {
	if ( ! $trip_id || ! $pricing ) {
		return;
	}
	$date_id = isset( $pricing['date_id'] ) ? $pricing['date_id'] : '';

	if ( ! $date_id ) {
		return;
	}
	$trip_times = get_post_meta( $trip_id, 'wp_travel_trip_time', true );
	$trip_time = is_array( $trip_times ) && isset( $trip_times[ $date_id ] ) ? $trip_times[ $date_id ] : array();
	
	$enable_trip_time = isset( $trip_time['enable_trip_time'] ) && 'yes' === $trip_time['enable_trip_time'] ? 'yes' : 'no';
	$times            = isset( $trip_time['times'] ) ? $trip_time['times'] : array();

	if ( 'yes' === $enable_trip_time && is_array( $times ) && count( $times ) > 0 ) { ?>
		<div class="timepicker-input">
			<select name="trip_time" id="wp-travel-trip-time" class="wp-travel-trip-time">
				<?php
				foreach ( $times as $time ) { ?>
					<option value="<?php echo esc_html( $time ); ?>" ><?php echo esc_html( $time ); ?></option>
				<?php
				} ?>
			</select>
		</div>
		<?php
	}
}

function wp_travel_trip_time_frontend_attrs( $trip_id ) {
	if ( ! $trip_id ) {
		return;
	} ?>
	<input type="hidden" value="" class="wp-travel-trip-time-input" name="trip_time" >
	<?php
}

// add attributes in cart.
function wp_travel_trip_time_cart_attributes( $attrs ) {

	if ( isset( $_POST['trip_time'] ) && ! empty( $_POST['trip_time'] ) ) {
		$attrs['trip_time'] = $_POST['trip_time'];
	}
	return $attrs;
}

// cart page
function wp_travel_trip_time_cart_page( $trip, $trip_id ) {
	if ( isset( $trip['trip_time'] ) && '' !== $trip['trip_time'] ) {

		echo '<br> <strong>Time:</strong> ' . esc_html( date('g:i a', strtotime( date('Y-m-d') . 'T' . $trip['trip_time'] . '' )) );
	}
}

add_filter( 'wp_travel_use_cart_trip_time', 'wp_travel_use_cart_trip_time', 11, 2 );
/**
 * Trip Time.
 * 
 * @since 4.0.0
 */
function wp_travel_use_cart_trip_time( $trip_time, $cart_item ) {

	if ( ! empty( $cart_item['trip_time'] ) ) {
		$time_format = get_option( 'time_format', 'g:i a' );
		$trip_time   = date_i18n( $time_format, strtotime( date('Y-m-d') . 'T' . $cart_item['trip_time'] . '' ) );
	}
	return $trip_time;
}

// Backend Booking detail page.
function wp_travel_trip_time_booking_detail_page( $order_details ) {
	if ( ! $order_details ) {
		return;
	}
	if ( is_array( $order_details ) && count( $order_details ) > 0 ) {
		echo '<strong>Time:</strong> ';

		foreach( $order_details as $order_detail ) {
	
			if ( isset( $order_detail['trip_time'] ) && '' !== $order_detail['trip_time'] ) {
				echo esc_html( $order_detail['trip_time'] ) . ', ';
			}
		}
	}
}

function wp_travel_email_trip_time( $date, $order_detail ) {
	if ( isset( $order_detail['trip_time'] ) && ! empty( $order_detail['trip_time'] ) ) {
		$date .= ' ' . $order_detail['trip_time'];
	}
	return $date;
}

add_filter( 'wp_travel_email_travel_date', 'wp_travel_email_trip_time', 10, 2 );
