<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Function to send zapier response for bookings automation.
 * If $is_testing is true then it will send only test responses.
 *
 * @param boolean $is_testing Default is false. If true, will only send the test response.
 * @param string  $booking_id  Trip booking ID.
 * @param string  $first_key   First key of the array.
 * @return void
 */
function wp_travel_zapier_bookings_automation( $is_testing = false, $booking_id = '', $first_key = '' ) {
	$test_webhook     = '';
	$api_response     = '';
	$webhook_endpoint = '';
	$settings         = function_exists( 'wptravel_get_settings' ) ? wptravel_get_settings() : wp_travel_get_settings();
	$enable_webhook   = ! empty( $settings['enable_booking_zapier_automation'] ) ? $settings['enable_booking_zapier_automation'] : '';
	$booking_fields   = ! empty( wptravel_get_checkout_form_fields() ) ? wptravel_get_checkout_form_fields() : array();
	/**
	 * Create array fields for the travel dates to retrive it later from booking-functions.php
	 */

	if ( isset( $booking_fields['traveller_fields'] ) ) {
		$booking_fields['traveller_fields']['arrival_date']['type']    = 'date';
		$booking_fields['traveller_fields']['arrival_date']['label']   = 'Arrival Date';
		$booking_fields['traveller_fields']['arrival_date']['name']    = 'wp_travel_arrival_date';
		$booking_fields['traveller_fields']['departure_date']['type']  = 'date';
		$booking_fields['traveller_fields']['departure_date']['label'] = 'Departure Date';
		$booking_fields['traveller_fields']['departure_date']['name']  = 'wp_travel_departure_date';
		$booking_fields['traveller_fields']['payment_type']['type']    = 'string';
		$booking_fields['traveller_fields']['payment_type']['label']   = 'Trip Price';
		$booking_fields['traveller_fields']['payment_type']['name']    = 'wp_travel_trip_price';
		$booking_fields['traveller_fields']['partial']['type']         = 'string';
		$booking_fields['traveller_fields']['partial']['label']        = 'Is Partial';
		$booking_fields['traveller_fields']['partial']['name']         = 'wp_travel_is_partial_payment';
	}
	if ( $is_testing ) {
		$booking_webhook = ! empty( $_POST['wp_travel_zapier_booking_webhook'] ) ? $_POST['wp_travel_zapier_booking_webhook'] : '';

		/**
		 * Start processing fields and data to create a api hook ready format.
		 */
		if ( ! empty( $booking_webhook ) && is_array( $booking_fields ) && count( $booking_fields ) > 0 ) {
			foreach ( $booking_fields as $booking_field ) {
				if ( ! empty( $booking_field ) ) {
					foreach ( $booking_field as $field ) {
						if ( isset( $field['label'] ) && 'hidden' !== $field['type'] ) {
							$webhook_endpoint .= $field['name'] . '=' . $field['label'] . '&';
						}
					}
				}
			}
			$webhook_endpoint .= 'booking_option=Booking Option&';
			$webhook_endpoint .= 'trip_extras=Trip Extras&';
			$webhook_endpoint .= 'trip_extras_price=Trip Extras Price&';
			$webhook_endpoint .= 'price_name=Price Name&';
			$webhook_endpoint .= 'price_category=Price Category&';
			$webhook_endpoint .= 'person=Number of Person&';
			$webhook_endpoint .= 'price_per_person=Price Per Person&';
			$webhook_endpoint .= 'trip_price=Trip Price&';
			$webhook_endpoint .= 'coupon_code=Coupon Code&';
			$webhook_endpoint .= 'coupon_code_type=Coupon Code Type&';
			$webhook_endpoint .= 'coupon_code_discount=Coupon Discount&';
			$webhook_endpoint .= 'total_price=Total Price&';
			$webhook_endpoint  = apply_filters( 'wp_travel_add_zapier_field_name', $webhook_endpoint );
			$test_webhook      = rtrim( $booking_webhook . '?' . $webhook_endpoint, '&' );
			/**
			 * Send api test response to the zapier if the webhooks is not empty.
			 */
			wp_remote_get( $test_webhook );
		}
	} else {
		if ( 'yes' !== $enable_webhook || empty( $booking_id ) || empty( $first_key ) ) {
			return;
		}

		$booking_webhook = ! empty( $settings['wp_travel_zapier_booking_webhook'] ) ? $settings['wp_travel_zapier_booking_webhook'] : '';
		/**
		 * Start processing fields and data to create a api hook ready format.
		 */
		if ( ! empty( $booking_webhook ) && is_array( $booking_fields ) && count( $booking_fields ) > 0 ) {
			foreach ( $booking_fields as $booking_field ) {
				if ( ! empty( $booking_field ) ) {
					foreach ( $booking_field as $field ) {
						if ( isset( $field['label'] ) && 'hidden' !== $field['type'] ) {
							$booking_data = get_post_meta( $booking_id, $field['name'], true );
							if ( is_array( $booking_data ) && isset( $booking_data[ $first_key ] ) ) {
								$webhook_endpoint .= $field['name'] . '=' . $booking_data[ $first_key ][0] . '&';
							} else {
								if ( is_array( $booking_data ) && count( $booking_data ) > 0 ) {
									$booking_data      = implode( ',', $booking_data );
									$webhook_endpoint .= $field['name'] . '=' . $booking_data . '&';
								} else {
									$webhook_endpoint .= $field['name'] . '=' . $booking_data . '&';
								}
							}
						}
					}
				}
			}
			$trip_extras_ids   = isset( get_post_meta( $booking_id, 'order_items_data', true )[ array_key_first( get_post_meta( $booking_id, 'order_items_data', true ) ) ]['trip_extras']['id'] ) ? get_post_meta( $booking_id, 'order_items_data', true )[ array_key_first( get_post_meta( $booking_id, 'order_items_data', true ) ) ]['trip_extras']['id'] : array();
			$trip_extras_qty   = isset( get_post_meta( $booking_id, 'order_items_data', true )[ array_key_first( get_post_meta( $booking_id, 'order_items_data', true ) ) ]['trip_extras']['qty'] ) ? get_post_meta( $booking_id, 'order_items_data', true )[ array_key_first( get_post_meta( $booking_id, 'order_items_data', true ) ) ]['trip_extras']['qty'] : array();
			$trip_extras_val   = '';
			$trip_extras_price = '';
			foreach ( $trip_extras_ids as $key => $value ) {
				$price             = get_post_meta( $value, 'wp_travel_tour_extras_metas', true )['extras_item_sale_price'] !== '' ? get_post_meta( $value, 'wp_travel_tour_extras_metas', true )['extras_item_sale_price'] : get_post_meta( $value, 'wp_travel_tour_extras_metas', true )['extras_item_price'];
				$quantity          = $trip_extras_qty[ $key ] . ' x ' . $price;
				$trip_extras_price = (float) $trip_extras_price + ( (float) $trip_extras_qty[ $key ] * (float) $price );
				if ( count( $trip_extras_ids ) !== ( $key + 1 ) ) {
					$trip_extras_val .= get_post( $value )->post_title . '( ' . $quantity . ' ), ';
				} else {
					$trip_extras_val .= get_post( $value )->post_title . '( ' . $quantity . ' )';
				}
			}
			global $wpdb;
			$table_name         = $wpdb->prefix . 'wt_pricings';
			$field_name         = 'title';
			$pricing_id         = (int) get_post_meta( $booking_id, 'order_items_data', true )[ array_key_first( get_post_meta( $booking_id, 'order_items_data', true ) ) ]['pricing_id'];
			$prepared_statement = $wpdb->prepare( "SELECT {$field_name} FROM {$table_name} WHERE  `id` = %d", $pricing_id );
			$price_name         = $wpdb->get_col( $prepared_statement );
			$pricing_cat        = '';
			$no_person          = '';
			$price_per_person   = '';
			foreach ( get_post_meta( $booking_id, 'order_items_data', true )[ array_key_first( get_post_meta( $booking_id, 'order_items_data', true ) ) ]['trip'] as $value ) {
				if ( $value['pax'] !== '0' ) {
					$pricing_cat      = $value['custom_label'];
					$no_person        = $value['pax'];
					$price_per_person = $value['price'];
				};
			}
			$total_price       = (float) get_post_meta( $booking_id, 'order_items_data', true )[ array_key_first( get_post_meta( $booking_id, 'order_items_data', true ) ) ]['trip_price'] + (float) $trip_extras_price;
			$trip_price_list   = array();
			if ( function_exists( 'wptravel_booking_data') ) {
				$trip_price_list = wptravel_booking_data( $booking_id );
			}
			$coupon_data		= get_post_meta( $booking_id, 'wp_travel_applied_coupon_data', true ); 
			$coupon_codes		= isset( $coupon_data['coupon_code'] ) ? $coupon_data['coupon_code'] : '';
			$coupon_type		= isset( $coupon_data['type'] ) ? $coupon_data['type'] : '';
			$coupon_discount   	= isset( $trip_price_list['discount'] ) ? $trip_price_list['discount'] : 0.00; 
			$total_trip_price  	= isset( $trip_price_list['total'] ) ? $trip_price_list['total'] : 0.00; 
			$webhook_endpoint .= 'booking_option=' . get_post_meta( $booking_id, 'order_data', true )['wp_travel_booking_option'] . '&';
			$webhook_endpoint .= 'trip_extras=' . $trip_extras_val . '&';
			$webhook_endpoint .= 'trip_extras_price=' . $trip_extras_price . '&';
			$webhook_endpoint .= 'price_name=' . $price_name[0] . '&';
			$webhook_endpoint .= 'price_category=' . $pricing_cat . '&';
			$webhook_endpoint .= 'person=' . $no_person . '&';
			$webhook_endpoint .= 'price_per_person=' . $price_per_person . '&';
			$webhook_endpoint .= 'trip_price=' . $total_price . '&';
			$webhook_endpoint .= 'coupon_code=' . $coupon_codes . '&';
			$webhook_endpoint .= 'coupon_code_type=' . $coupon_type . '&';
			$webhook_endpoint .= 'coupon_code_discount=' . $coupon_discount . '&';
			$webhook_endpoint .= 'total_price=' . $total_trip_price . '&';
			$webhook_endpoint  = apply_filters( 'wp_travel_zapier_field_value', $webhook_endpoint, $booking_id, $trip_price_list, $coupon_data );
			$api_response      = rtrim( $booking_webhook . '?' . $webhook_endpoint, '&' );
			/**
			 * Send main api response to the zapier if the webhooks is not empty.
			 */

			wp_remote_get( $api_response );
		}
	}
}
/**
 * Function to send zapier response for enquiry automation.
 * If $is_testing is true then it will send only test responses.
 *
 * @param boolean $is_testing  Default is false. If true, will only send the test response.
 * @param string  $post_id      Enquiry post Id.
 * @param string  $enquiry_data Submitted enquiry data.
 * @return void
 */
function wp_travel_zapier_enquiry_automation( $is_testing = false, $post_id = '', $enquiry_data = '' ) {
	$test_webhook     = '';
	$api_response     = '';
	$new_data         = '';
	$webhook_endpoint = '';
	$settings         = ! empty( wptravel_get_settings() ) ? wptravel_get_settings() : array();
	$enable_webhook   = ! empty( $settings['enable_enquiry_zapier_automation'] ) ? $settings['enable_enquiry_zapier_automation'] : '';
	$enquiry_fields   = ! empty( wptravel_enquiries_form_fields() ) ? wptravel_enquiries_form_fields() : array();
	if ( $is_testing ) {
		$enquiry_webhook = ! empty( $_POST['wp_travel_zapier_enquiry_webhook'] ) ? $_POST['wp_travel_zapier_enquiry_webhook'] : '';
		if ( ! empty( $enquiry_webhook ) && is_array( $enquiry_fields ) && count( $enquiry_fields ) > 0 ) {
			foreach ( $enquiry_fields as $enquiry_field ) {
				$webhook_endpoint .= $enquiry_field['name'] . '=' . $enquiry_field['label'] . '&';
			}
			$test_webhook = rtrim( $enquiry_webhook . '?' . $webhook_endpoint, '&' );
			wp_remote_get( $test_webhook );
		}
	} else {
		if ( empty( $enquiry_data ) ) {
			return;
		}
		$enquiry_webhook = ! empty( $settings['wp_travel_zapier_enquiry_webhook'] ) ? $settings['wp_travel_zapier_enquiry_webhook'] : '';
		if ( 'yes' === $enable_webhook ) {
			if ( ! empty( $enquiry_webhook ) ) {
				foreach ( $enquiry_fields as $enquiry_field ) {
					if ( ! is_array( $enquiry_data[ $enquiry_field['name'] ] ) && ! empty( $enquiry_data[ $enquiry_field['name'] ] ) ) {
						$webhook_endpoint .= $enquiry_field['name'] . '=' . $enquiry_data[ $enquiry_field['name'] ] . '&';
					}
					if ( is_array( $enquiry_data[ $enquiry_field['name'] ] ) && ! empty( $enquiry_data[ $enquiry_field['name'] ] ) && count( $enquiry_data[ $enquiry_field['name'] ] ) > 0 ) {
						foreach ( $enquiry_data[ $enquiry_field['name'] ] as $new_data_values ) {
							$new_data .= $new_data_values . ',';
						}
						$enquiry_data[ $enquiry_field['name'] ] = rtrim( $new_data, ',' );
						$webhook_endpoint                      .= $enquiry_field['name'] . '=' . $enquiry_data[ $enquiry_field['name'] ] . '&';
					}
				}
				$api_response = rtrim( $enquiry_webhook . '?' . $webhook_endpoint, '&' );
				wp_remote_get( $api_response );
			}
		}
	}
}
